/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flume.instrumentation.kafka;

import org.apache.flume.instrumentation.SourceCounter;
import org.apache.flume.instrumentation.kafka.KafkaSourceCounterMBean;

public class KafkaSourceCounter
extends SourceCounter
implements KafkaSourceCounterMBean {
    private static final String TIMER_KAFKA_EVENT_GET = "source.kafka.event.get.time";
    private static final String TIMER_KAFKA_COMMIT = "source.kafka.commit.time";
    private static final String COUNTER_KAFKA_EMPTY = "source.kafka.empty.count";
    private static final String[] ATTRIBUTES = new String[]{"source.kafka.commit.time", "source.kafka.event.get.time", "source.kafka.empty.count"};

    public KafkaSourceCounter(String name) {
        super(name, ATTRIBUTES);
    }

    public long addToKafkaEventGetTimer(long delta) {
        return this.addAndGet(TIMER_KAFKA_EVENT_GET, delta);
    }

    public long addToKafkaCommitTimer(long delta) {
        return this.addAndGet(TIMER_KAFKA_COMMIT, delta);
    }

    public long incrementKafkaEmptyCount() {
        return this.increment(COUNTER_KAFKA_EMPTY);
    }

    @Override
    public long getKafkaCommitTimer() {
        return this.get(TIMER_KAFKA_COMMIT);
    }

    @Override
    public long getKafkaEventGetTimer() {
        return this.get(TIMER_KAFKA_EVENT_GET);
    }

    @Override
    public long getKafkaEmptyCount() {
        return this.get(COUNTER_KAFKA_EMPTY);
    }
}

