/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flume.instrumentation.kafka;

import org.apache.flume.instrumentation.SinkCounter;
import org.apache.flume.instrumentation.kafka.KafkaSinkCounterMBean;

public class KafkaSinkCounter
extends SinkCounter
implements KafkaSinkCounterMBean {
    private static final String TIMER_KAFKA_EVENT_SEND = "channel.kafka.event.send.time";
    private static final String COUNT_ROLLBACK = "channel.rollback.count";
    private static final String[] ATTRIBUTES = new String[]{"channel.rollback.count", "channel.kafka.event.send.time"};

    public KafkaSinkCounter(String name) {
        super(name, ATTRIBUTES);
    }

    public long addToKafkaEventSendTimer(long delta) {
        return this.addAndGet(TIMER_KAFKA_EVENT_SEND, delta);
    }

    public long incrementRollbackCount() {
        return this.increment(COUNT_ROLLBACK);
    }

    @Override
    public long getKafkaEventSendTimer() {
        return this.get(TIMER_KAFKA_EVENT_SEND);
    }

    @Override
    public long getRollbackCount() {
        return this.get(COUNT_ROLLBACK);
    }
}

