/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flume.instrumentation;

import org.apache.commons.lang.ArrayUtils;
import org.apache.flume.instrumentation.ChannelCounterMBean;
import org.apache.flume.instrumentation.MonitoredCounterGroup;

public class ChannelCounter
extends MonitoredCounterGroup
implements ChannelCounterMBean {
    private static final String COUNTER_CHANNEL_SIZE = "channel.current.size";
    private static final String COUNTER_EVENT_PUT_ATTEMPT = "channel.event.put.attempt";
    private static final String COUNTER_EVENT_TAKE_ATTEMPT = "channel.event.take.attempt";
    private static final String COUNTER_EVENT_PUT_SUCCESS = "channel.event.put.success";
    private static final String COUNTER_EVENT_TAKE_SUCCESS = "channel.event.take.success";
    private static final String COUNTER_CHANNEL_CAPACITY = "channel.capacity";
    private static final String[] ATTRIBUTES = new String[]{"channel.current.size", "channel.event.put.attempt", "channel.event.take.attempt", "channel.event.put.success", "channel.event.take.success", "channel.capacity"};

    public ChannelCounter(String name) {
        super(MonitoredCounterGroup.Type.CHANNEL, name, ATTRIBUTES);
    }

    public ChannelCounter(String name, String[] attributes) {
        super(MonitoredCounterGroup.Type.CHANNEL, name, (String[])ArrayUtils.addAll((Object[])attributes, (Object[])ATTRIBUTES));
    }

    @Override
    public long getChannelSize() {
        return this.get(COUNTER_CHANNEL_SIZE);
    }

    public void setChannelSize(long newSize) {
        this.set(COUNTER_CHANNEL_SIZE, newSize);
    }

    @Override
    public long getEventPutAttemptCount() {
        return this.get(COUNTER_EVENT_PUT_ATTEMPT);
    }

    public long incrementEventPutAttemptCount() {
        return this.increment(COUNTER_EVENT_PUT_ATTEMPT);
    }

    @Override
    public long getEventTakeAttemptCount() {
        return this.get(COUNTER_EVENT_TAKE_ATTEMPT);
    }

    public long incrementEventTakeAttemptCount() {
        return this.increment(COUNTER_EVENT_TAKE_ATTEMPT);
    }

    @Override
    public long getEventPutSuccessCount() {
        return this.get(COUNTER_EVENT_PUT_SUCCESS);
    }

    public long addToEventPutSuccessCount(long delta) {
        return this.addAndGet(COUNTER_EVENT_PUT_SUCCESS, delta);
    }

    @Override
    public long getEventTakeSuccessCount() {
        return this.get(COUNTER_EVENT_TAKE_SUCCESS);
    }

    public long addToEventTakeSuccessCount(long delta) {
        return this.addAndGet(COUNTER_EVENT_TAKE_SUCCESS, delta);
    }

    public void setChannelCapacity(long capacity) {
        this.set(COUNTER_CHANNEL_CAPACITY, capacity);
    }

    @Override
    public long getChannelCapacity() {
        return this.get(COUNTER_CHANNEL_CAPACITY);
    }

    @Override
    public double getChannelFillPercentage() {
        long capacity = this.getChannelCapacity();
        if (capacity != 0L) {
            return (double)this.getChannelSize() / (double)capacity * 100.0;
        }
        return Double.MAX_VALUE;
    }
}

