/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.ml.util;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.ignite.lang.IgniteBiTuple;
import org.jetbrains.annotations.NotNull;

public class ModelTrace {
    private final String mdlName;
    private final boolean pretty;
    private List<IgniteBiTuple<String, Object>> mdlFields = new ArrayList<IgniteBiTuple<String, Object>>();

    public static ModelTrace builder(String mdlName, boolean pretty) {
        return new ModelTrace(mdlName, pretty);
    }

    public static ModelTrace builder(String mdlName) {
        return new ModelTrace(mdlName, false);
    }

    private ModelTrace(String mdlName, boolean pretty) {
        this.mdlName = mdlName;
        this.pretty = pretty;
    }

    public ModelTrace addField(String name, String val) {
        this.mdlFields.add((IgniteBiTuple<String, Object>)new IgniteBiTuple((Object)name, (Object)val));
        return this;
    }

    public ModelTrace addField(String name, List values) {
        this.mdlFields.add((IgniteBiTuple<String, Object>)new IgniteBiTuple((Object)name, (Object)values));
        return this;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        String ending = this.pretty ? "\n" : "";
        String fields = this.mdlFields.stream().map(kv -> this.fieldToString((IgniteBiTuple<String, Object>)kv, this.pretty)).collect(Collectors.joining(this.pretty ? ",\n" : ", "));
        builder.append(this.mdlName).append(" [").append(ending).append(fields).append(ending).append("]");
        return builder.toString();
    }

    @NotNull
    private String fieldToString(IgniteBiTuple<String, Object> kv, boolean pretty) {
        StringBuilder builder = new StringBuilder(pretty ? "\t" : "").append((String)kv.getKey()).append(" = [");
        if (kv.getValue() instanceof List) {
            List list = (List)kv.getValue();
            builder.append(pretty ? "\n" : "").append((Object)list.stream().map(x -> (pretty ? "\t\t" : "") + x).collect(Collectors.joining(pretty ? ",\n" : ", "))).append(pretty ? "\n\t]" : "]");
        } else {
            builder.append(kv.getValue().toString()).append("]");
        }
        return builder.toString();
    }
}

