/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.ml.tree.randomforest.data.statistics;

import org.apache.ignite.ml.dataset.impl.bootstrapping.BootstrappedVector;
import org.apache.ignite.ml.tree.randomforest.data.statistics.LeafValuesComputer;
import org.apache.ignite.ml.tree.randomforest.data.statistics.MeanValueStatistic;

public class RegressionLeafValuesComputer
extends LeafValuesComputer<MeanValueStatistic> {
    private static final long serialVersionUID = -1898031675220962125L;

    @Override
    protected void addElementToLeafStatistic(MeanValueStatistic leafStatAggr, BootstrappedVector vec, int sampleId) {
        int numOfRepetitions = vec.counters()[sampleId];
        leafStatAggr.setSumOfValues(leafStatAggr.getSumOfValues() + (Double)vec.label() * (double)numOfRepetitions);
        leafStatAggr.setCntOfValues(leafStatAggr.getCntOfValues() + (long)numOfRepetitions);
    }

    @Override
    protected MeanValueStatistic mergeLeafStats(MeanValueStatistic leftStats, MeanValueStatistic rightStats) {
        return new MeanValueStatistic(leftStats.getSumOfValues() + rightStats.getSumOfValues(), leftStats.getCntOfValues() + rightStats.getCntOfValues());
    }

    @Override
    protected MeanValueStatistic createLeafStatsAggregator(int sampleId) {
        return new MeanValueStatistic(0.0, 0L);
    }

    @Override
    protected double computeLeafValue(MeanValueStatistic stat) {
        return stat.mean();
    }
}

