/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.ml.tree.randomforest.data;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.ignite.ml.Model;
import org.apache.ignite.ml.math.primitives.vector.Vector;
import org.apache.ignite.ml.tree.randomforest.data.TreeNode;

public class TreeRoot
implements Model<Vector, Double> {
    private static final long serialVersionUID = 531797299171329057L;
    private TreeNode node;
    private Set<Integer> usedFeatures;

    public TreeRoot(TreeNode root, Set<Integer> usedFeatures) {
        this.node = root;
        this.usedFeatures = usedFeatures;
    }

    @Override
    public Double apply(Vector vector) {
        return this.node.apply(vector);
    }

    public Set<Integer> getUsedFeatures() {
        return this.usedFeatures;
    }

    public TreeNode getRootNode() {
        return this.node;
    }

    public List<TreeNode> getLeafs() {
        ArrayList<TreeNode> res = new ArrayList<TreeNode>();
        this.getLeafs(this.node, res);
        return res;
    }

    private void getLeafs(TreeNode root, List<TreeNode> res) {
        if (root.getType() == TreeNode.Type.LEAF) {
            res.add(root);
        } else {
            this.getLeafs(root.getLeft(), res);
            this.getLeafs(root.getRight(), res);
        }
    }
}

