/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.ml.tree.impurity.util;

import java.util.Arrays;
import org.apache.ignite.ml.tree.impurity.ImpurityMeasure;

public class StepFunction<T extends ImpurityMeasure<T>> {
    private final double[] x;
    private final T[] y;

    public StepFunction(double[] x, T[] y) {
        assert (x.length == y.length) : "Argument and value arrays have to be the same length";
        this.x = x;
        this.y = y;
        this.sort(x, (ImpurityMeasure[])y, 0, x.length - 1);
    }

    public StepFunction<T> add(StepFunction<T> b) {
        int resSize = 0;
        int leftPtr = 0;
        int rightPtr = 0;
        double previousPnt = 0.0;
        while (leftPtr < this.x.length || rightPtr < b.x.length) {
            if (rightPtr >= b.x.length || leftPtr < this.x.length && this.x[leftPtr] < b.x[rightPtr]) {
                if (resSize == 0 || this.x[leftPtr] != previousPnt) {
                    previousPnt = this.x[leftPtr];
                    ++resSize;
                }
                ++leftPtr;
                continue;
            }
            if (resSize == 0 || b.x[rightPtr] != previousPnt) {
                previousPnt = b.x[rightPtr];
                ++resSize;
            }
            ++rightPtr;
        }
        double[] resX = new double[resSize];
        ImpurityMeasure[] resY = (ImpurityMeasure[])Arrays.copyOf(this.y, resSize);
        leftPtr = 0;
        rightPtr = 0;
        int i = 0;
        while (leftPtr < this.x.length || rightPtr < b.x.length) {
            int target;
            boolean override;
            if (rightPtr >= b.x.length || leftPtr < this.x.length && this.x[leftPtr] < b.x[rightPtr]) {
                override = i > 0 && this.x[leftPtr] == resX[i - 1];
                target = override ? i - 1 : i;
                resY[target] = override ? resY[target] : null;
                resY[target] = i > 0 ? resY[i - 1] : null;
                Object object = resY[target] = resY[target] == null ? this.y[leftPtr] : resY[target].add(this.y[leftPtr]);
                if (leftPtr > 0) {
                    resY[target] = resY[target].subtract(this.y[leftPtr - 1]);
                }
                resX[target] = this.x[leftPtr];
                i = target;
                ++leftPtr;
            } else {
                override = i > 0 && b.x[rightPtr] == resX[i - 1];
                target = override ? i - 1 : i;
                resY[target] = override ? resY[target] : null;
                resY[target] = i > 0 ? resY[i - 1] : null;
                Object object = resY[target] = resY[target] == null ? b.y[rightPtr] : resY[target].add(b.y[rightPtr]);
                if (rightPtr > 0) {
                    resY[target] = resY[target].subtract(b.y[rightPtr - 1]);
                }
                resX[target] = b.x[rightPtr];
                i = target;
                ++rightPtr;
            }
            ++i;
        }
        return new StepFunction(resX, resY);
    }

    private void sort(double[] x, T[] y, int from, int to) {
        if (from < to) {
            double pivot = x[(from + to) / 2];
            int i = from;
            int j = to;
            while (i <= j) {
                while (x[i] < pivot) {
                    ++i;
                }
                while (x[j] > pivot) {
                    --j;
                }
                if (i > j) continue;
                double tmpX = x[i];
                x[i] = x[j];
                x[j] = tmpX;
                T tmpY = y[i];
                y[i] = y[j];
                y[j] = tmpY;
                ++i;
                --j;
            }
            this.sort(x, (ImpurityMeasure[])y, from, j);
            this.sort(x, (ImpurityMeasure[])y, i, to);
        }
    }

    public double[] getX() {
        return this.x;
    }

    public T[] getY() {
        return this.y;
    }
}

