/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.ml.tree.data;

import java.io.Serializable;
import java.util.Iterator;
import org.apache.ignite.ml.dataset.PartitionDataBuilder;
import org.apache.ignite.ml.dataset.UpstreamEntry;
import org.apache.ignite.ml.math.functions.IgniteBiFunction;
import org.apache.ignite.ml.math.primitives.vector.Vector;
import org.apache.ignite.ml.tree.data.DecisionTreeData;

public class DecisionTreeDataBuilder<K, V, C extends Serializable>
implements PartitionDataBuilder<K, V, C, DecisionTreeData> {
    private static final long serialVersionUID = 3678784980215216039L;
    private final IgniteBiFunction<K, V, Vector> featureExtractor;
    private final IgniteBiFunction<K, V, Double> lbExtractor;
    private final boolean buildIdx;

    public DecisionTreeDataBuilder(IgniteBiFunction<K, V, Vector> featureExtractor, IgniteBiFunction<K, V, Double> lbExtractor, boolean buildIdx) {
        this.featureExtractor = featureExtractor;
        this.lbExtractor = lbExtractor;
        this.buildIdx = buildIdx;
    }

    @Override
    public DecisionTreeData build(Iterator<UpstreamEntry<K, V>> upstreamData, long upstreamDataSize, C ctx) {
        double[][] features = new double[Math.toIntExact(upstreamDataSize)][];
        double[] labels = new double[Math.toIntExact(upstreamDataSize)];
        int ptr = 0;
        while (upstreamData.hasNext()) {
            UpstreamEntry<K, V> entry = upstreamData.next();
            features[ptr] = ((Vector)this.featureExtractor.apply(entry.getKey(), entry.getValue())).asArray();
            labels[ptr] = (Double)this.lbExtractor.apply(entry.getKey(), entry.getValue());
            ++ptr;
        }
        return new DecisionTreeData(features, labels, this.buildIdx);
    }
}

