/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.ml.regressions.linear;

import java.util.Arrays;
import org.apache.ignite.ml.math.functions.IgniteBiFunction;
import org.apache.ignite.ml.math.primitives.vector.Vector;
import org.apache.ignite.ml.math.primitives.vector.VectorUtils;

public class FeatureExtractorWrapper<K, V>
implements IgniteBiFunction<K, V, Vector> {
    private static final long serialVersionUID = -2686524650955735635L;
    private final IgniteBiFunction<K, V, Vector> featureExtractor;

    FeatureExtractorWrapper(IgniteBiFunction<K, V, Vector> featureExtractor) {
        this.featureExtractor = featureExtractor;
    }

    @Override
    public Vector apply(K k, V v) {
        double[] featureRow = ((Vector)this.featureExtractor.apply(k, v)).asArray();
        double[] row = Arrays.copyOf(featureRow, featureRow.length + 1);
        row[featureRow.length] = 1.0;
        return VectorUtils.of(row);
    }
}

