/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.ml.preprocessing.normalization;

import org.apache.ignite.ml.math.functions.Functions;
import org.apache.ignite.ml.math.functions.IgniteBiFunction;
import org.apache.ignite.ml.math.functions.IgniteDoubleFunction;
import org.apache.ignite.ml.math.primitives.vector.Vector;

public class NormalizationPreprocessor<K, V>
implements IgniteBiFunction<K, V, Vector> {
    private static final long serialVersionUID = 6873438115778921295L;
    private int p;
    private final IgniteBiFunction<K, V, Vector> basePreprocessor;

    public NormalizationPreprocessor(int p, IgniteBiFunction<K, V, Vector> basePreprocessor) {
        this.p = p;
        this.basePreprocessor = basePreprocessor;
    }

    @Override
    public Vector apply(K k, V v) {
        Vector res = (Vector)this.basePreprocessor.apply(k, v);
        double pNorm = Math.pow(this.foldMap(res, Functions.PLUS, Functions.pow(this.p), 0.0), 1.0 / (double)this.p);
        for (int i = 0; i < res.size(); ++i) {
            res.set(i, res.get(i) / pNorm);
        }
        return res;
    }

    private double foldMap(Vector vec, IgniteBiFunction<Double, Double, Double> foldFun, IgniteDoubleFunction<Double> mapFun, double zero) {
        for (int i = 0; i < vec.size(); ++i) {
            zero = (Double)foldFun.apply(zero, (Double)mapFun.apply(vec.get(i)));
        }
        return zero;
    }

    public double p() {
        return this.p;
    }
}

