/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.ml.preprocessing.maxabsscaling;

import org.apache.ignite.ml.dataset.Dataset;
import org.apache.ignite.ml.dataset.DatasetBuilder;
import org.apache.ignite.ml.dataset.UpstreamEntry;
import org.apache.ignite.ml.dataset.primitive.context.EmptyContext;
import org.apache.ignite.ml.math.functions.IgniteBiFunction;
import org.apache.ignite.ml.math.primitives.vector.Vector;
import org.apache.ignite.ml.preprocessing.PreprocessingTrainer;
import org.apache.ignite.ml.preprocessing.maxabsscaling.MaxAbsScalerPartitionData;
import org.apache.ignite.ml.preprocessing.maxabsscaling.MaxAbsScalerPreprocessor;

public class MaxAbsScalerTrainer<K, V>
implements PreprocessingTrainer<K, V, Vector, Vector> {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public MaxAbsScalerPreprocessor<K, V> fit(DatasetBuilder<K, V> datasetBuilder, IgniteBiFunction<K, V, Vector> basePreprocessor) {
        try (Dataset<EmptyContext, MaxAbsScalerPartitionData> dataset = datasetBuilder.build((upstream, upstreamSize) -> new EmptyContext(), (upstream, upstreamSize, ctx) -> {
            double[] maxAbs = null;
            while (upstream.hasNext()) {
                int i;
                UpstreamEntry entity = (UpstreamEntry)upstream.next();
                Vector row = (Vector)basePreprocessor.apply(entity.getKey(), entity.getValue());
                if (maxAbs == null) {
                    maxAbs = new double[row.size()];
                    for (i = 0; i < maxAbs.length; ++i) {
                        maxAbs[i] = 0.0;
                    }
                } else assert (maxAbs.length == row.size()) : "Base preprocessor must return exactly " + maxAbs.length + " features";
                for (i = 0; i < row.size(); ++i) {
                    if (!(Math.abs(row.get(i)) > Math.abs(maxAbs[i]))) continue;
                    maxAbs[i] = Math.abs(row.get(i));
                }
            }
            return new MaxAbsScalerPartitionData(maxAbs);
        });){
            double[] maxAbs = (double[])dataset.compute(MaxAbsScalerPartitionData::getMaxAbs, (a, b) -> {
                if (a == null) {
                    return b;
                }
                if (b == null) {
                    return a;
                }
                double[] res = new double[((double[])a).length];
                for (int i = 0; i < res.length; ++i) {
                    res[i] = Math.max(Math.abs(a[i]), Math.abs(b[i]));
                }
                return res;
            });
            MaxAbsScalerPreprocessor<K, V> maxAbsScalerPreprocessor = new MaxAbsScalerPreprocessor<K, V>(maxAbs, basePreprocessor);
            return maxAbsScalerPreprocessor;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

