/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.ml.preprocessing.maxabsscaling;

import org.apache.ignite.ml.math.functions.IgniteBiFunction;
import org.apache.ignite.ml.math.primitives.vector.Vector;

public class MaxAbsScalerPreprocessor<K, V>
implements IgniteBiFunction<K, V, Vector> {
    private static final long serialVersionUID = 1L;
    private final double[] maxAbs;
    private final IgniteBiFunction<K, V, Vector> basePreprocessor;

    public MaxAbsScalerPreprocessor(double[] maxAbs, IgniteBiFunction<K, V, Vector> basePreprocessor) {
        this.maxAbs = maxAbs;
        this.basePreprocessor = basePreprocessor;
    }

    @Override
    public Vector apply(K k, V v) {
        Vector res = (Vector)this.basePreprocessor.apply(k, v);
        assert (res.size() == this.maxAbs.length);
        for (int i = 0; i < res.size(); ++i) {
            res.set(i, res.get(i) / this.maxAbs[i]);
        }
        return res;
    }

    public double[] getMaxAbs() {
        return this.maxAbs;
    }
}

