/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.ml.preprocessing.encoding.onehotencoder;

import java.util.Map;
import java.util.Set;
import org.apache.ignite.ml.math.exceptions.preprocessing.UnknownCategorialFeatureValue;
import org.apache.ignite.ml.math.functions.IgniteBiFunction;
import org.apache.ignite.ml.math.primitives.vector.Vector;
import org.apache.ignite.ml.math.primitives.vector.VectorUtils;
import org.apache.ignite.ml.preprocessing.encoding.EncoderPreprocessor;

public class OneHotEncoderPreprocessor<K, V>
extends EncoderPreprocessor<K, V> {
    private static final long serialVersionUID = 6237812226552623469L;

    public OneHotEncoderPreprocessor(Map<String, Integer>[] encodingValues, IgniteBiFunction<K, V, Object[]> basePreprocessor, Set<Integer> handledIndices) {
        super(encodingValues, basePreprocessor, handledIndices);
    }

    @Override
    public Vector apply(K k, V v) {
        Object[] tmp = (Object[])this.basePreprocessor.apply(k, v);
        double[] res = new double[tmp.length + this.getAdditionalSize(this.encodingValues)];
        int categorialFeatureCntr = 0;
        for (int i = 0; i < tmp.length; ++i) {
            Object tmpObj = tmp[i];
            if (this.handledIndices.contains(i)) {
                ++categorialFeatureCntr;
                if (tmpObj.equals(Double.NaN) && this.encodingValues[i].containsKey("")) {
                    Integer indexedVal = (Integer)this.encodingValues[i].get("");
                    res[i] = indexedVal.intValue();
                    res[tmp.length + this.getIdxOffset((int)categorialFeatureCntr, (int)indexedVal.intValue(), this.encodingValues)] = 1.0;
                    continue;
                }
                String key = String.valueOf(tmpObj);
                if (this.encodingValues[i].containsKey(key)) {
                    Integer indexedVal = (Integer)this.encodingValues[i].get(key);
                    res[i] = indexedVal.intValue();
                    res[tmp.length + this.getIdxOffset((int)categorialFeatureCntr, (int)indexedVal.intValue(), this.encodingValues)] = 1.0;
                    continue;
                }
                throw new UnknownCategorialFeatureValue(tmpObj.toString());
            }
            res[i] = (Double)tmpObj;
        }
        return VectorUtils.of(res);
    }

    private int getAdditionalSize(Map<String, Integer>[] encodingValues) {
        int newSize = 0;
        for (Map<String, Integer> encodingValue : encodingValues) {
            if (encodingValue == null) continue;
            newSize += encodingValue.size();
        }
        return newSize;
    }

    private int getIdxOffset(int categorialFeatureCntr, int indexedVal, Map<String, Integer>[] encodingValues) {
        int idxOff = 0;
        int locCategorialFeatureCntr = 1;
        int i = 0;
        while (locCategorialFeatureCntr < categorialFeatureCntr) {
            if (encodingValues[i] != null) {
                ++locCategorialFeatureCntr;
                idxOff += encodingValues[i].size();
            }
            ++i;
        }
        return idxOff += indexedVal;
    }
}

