/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.ml.nn;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Map;
import java.util.Spliterator;
import org.apache.ignite.lang.IgniteUuid;
import org.apache.ignite.ml.math.exceptions.CardinalityException;
import org.apache.ignite.ml.math.functions.IgniteBiConsumer;
import org.apache.ignite.ml.math.functions.IgniteBiFunction;
import org.apache.ignite.ml.math.functions.IgniteDoubleFunction;
import org.apache.ignite.ml.math.functions.IgniteFunction;
import org.apache.ignite.ml.math.functions.IgniteTriFunction;
import org.apache.ignite.ml.math.functions.IntIntToDoubleFunction;
import org.apache.ignite.ml.math.primitives.matrix.Matrix;
import org.apache.ignite.ml.math.primitives.matrix.MatrixStorage;
import org.apache.ignite.ml.math.primitives.matrix.impl.DenseMatrix;
import org.apache.ignite.ml.math.primitives.vector.Vector;

class ReplicatedVectorMatrix
implements Matrix {
    private Vector vector;
    private boolean asCol;
    private int replicationCnt;

    ReplicatedVectorMatrix(Vector vector, int replicationCnt, boolean asCol) {
        this.vector = vector;
        this.asCol = asCol;
        this.replicationCnt = replicationCnt;
    }

    public ReplicatedVectorMatrix() {
    }

    @Override
    public boolean isSequentialAccess() {
        return this.vector.isSequentialAccess();
    }

    @Override
    public boolean isRandomAccess() {
        return this.vector.isRandomAccess();
    }

    @Override
    public boolean isDense() {
        return this.vector.isDense();
    }

    @Override
    public boolean isArrayBased() {
        return this.vector.isArrayBased();
    }

    @Override
    public boolean isDistributed() {
        return this.vector.isDistributed();
    }

    @Override
    public double maxValue() {
        return this.vector.maxValue();
    }

    @Override
    public double minValue() {
        return this.vector.minValue();
    }

    @Override
    public Matrix.Element maxElement() {
        return new Matrix.Element(){

            @Override
            public double get() {
                return ReplicatedVectorMatrix.this.vector.maxElement().get();
            }

            @Override
            public int row() {
                return ReplicatedVectorMatrix.this.asCol ? ReplicatedVectorMatrix.this.vector.maxElement().index() : 0;
            }

            @Override
            public int column() {
                return ReplicatedVectorMatrix.this.asCol ? 0 : ReplicatedVectorMatrix.this.vector.maxElement().index();
            }

            @Override
            public void set(double val) {
            }
        };
    }

    @Override
    public Matrix.Element minElement() {
        return new Matrix.Element(){

            @Override
            public double get() {
                return ReplicatedVectorMatrix.this.vector.minElement().get();
            }

            @Override
            public int row() {
                return ReplicatedVectorMatrix.this.asCol ? ReplicatedVectorMatrix.this.vector.minElement().index() : 0;
            }

            @Override
            public int column() {
                return ReplicatedVectorMatrix.this.asCol ? 0 : ReplicatedVectorMatrix.this.vector.minElement().index();
            }

            @Override
            public void set(double val) {
            }
        };
    }

    @Override
    public Matrix.Element getElement(int row, int col) {
        final Vector.Element el = this.asCol ? this.vector.getElement(row) : this.vector.getElement(col);
        final int r = this.asCol ? el.index() : 0;
        final int c = this.asCol ? 0 : el.index();
        return new Matrix.Element(){

            @Override
            public double get() {
                return el.get();
            }

            @Override
            public int row() {
                return r;
            }

            @Override
            public int column() {
                return c;
            }

            @Override
            public void set(double val) {
            }
        };
    }

    @Override
    public Matrix swapRows(int row1, int row2) {
        return this.asCol ? new ReplicatedVectorMatrix(this.swap(row1, row2), this.replicationCnt, this.asCol) : this;
    }

    private Vector swap(int idx1, int idx2) {
        double val = this.vector.getX(idx1);
        this.vector.setX(idx1, this.vector.getX(idx2));
        this.vector.setX(idx2, val);
        return this.vector;
    }

    @Override
    public Matrix swapColumns(int col1, int col2) {
        return this.asCol ? this : new ReplicatedVectorMatrix(this.swap(col1, col2), this.replicationCnt, this.asCol);
    }

    @Override
    public Matrix assign(double val) {
        return new ReplicatedVectorMatrix(this.vector.assign(val), this.replicationCnt, this.asCol);
    }

    @Override
    public Matrix assign(double[][] vals) {
        return new DenseMatrix(vals);
    }

    @Override
    public Matrix assign(Matrix mtx) {
        return mtx.copy();
    }

    @Override
    public Matrix assign(IntIntToDoubleFunction fun) {
        Vector vec = this.asCol ? this.vector.assign((int idx) -> (Double)fun.apply(idx, 0)) : this.vector.assign((int idx) -> (Double)fun.apply(0, idx));
        return new ReplicatedVectorMatrix(vec, this.replicationCnt, this.asCol);
    }

    @Override
    public Matrix map(IgniteDoubleFunction<Double> fun) {
        Vector vec = this.vector.map(fun);
        return new ReplicatedVectorMatrix(vec, this.replicationCnt, this.asCol);
    }

    @Override
    public Matrix map(Matrix mtx, IgniteBiFunction<Double, Double, Double> fun) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int nonZeroElements() {
        return this.vector.nonZeroElements() * (this.asCol ? this.columnSize() : this.rowSize());
    }

    @Override
    public Spliterator<Double> allSpliterator() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Spliterator<Double> nonZeroSpliterator() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Matrix assignColumn(int col, Vector vec) {
        int rows = this.asCol ? this.vector.size() : this.replicationCnt;
        int cols = this.asCol ? this.replicationCnt : this.vector.size();
        int times = this.asCol ? cols : rows;
        DenseMatrix res = new DenseMatrix(rows, cols);
        IgniteBiConsumer replicantAssigner = this.asCol ? res::assignColumn : res::assignRow;
        IgniteBiConsumer assigner = res::assignColumn;
        this.assign(replicantAssigner, assigner, this.vector, vec, times, col);
        return res;
    }

    @Override
    public Matrix assignRow(int row, Vector vec) {
        int rows = this.asCol ? this.vector.size() : this.replicationCnt;
        int cols = this.asCol ? this.replicationCnt : this.vector.size();
        int times = this.asCol ? cols : rows;
        DenseMatrix res = new DenseMatrix(rows, cols);
        IgniteBiConsumer replicantAssigner = this.asCol ? res::assignColumn : res::assignRow;
        IgniteBiConsumer assigner = res::assignRow;
        this.assign(replicantAssigner, assigner, this.vector, vec, times, row);
        return res;
    }

    private void assign(IgniteBiConsumer<Integer, Vector> replicantAssigner, IgniteBiConsumer<Integer, Vector> assigner, Vector replicant, Vector vector, int times, int idx) {
        for (int i = 0; i < times; ++i) {
            replicantAssigner.accept(i, replicant);
        }
        assigner.accept(idx, vector);
    }

    @Override
    public Vector foldRows(IgniteFunction<Vector, Double> fun) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Vector foldColumns(IgniteFunction<Vector, Double> fun) {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> T foldMap(IgniteBiFunction<T, Double, T> foldFun, IgniteDoubleFunction<Double> mapFun, T zeroVal) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean density(double threshold) {
        return false;
    }

    @Override
    public int columnSize() {
        return this.asCol ? this.replicationCnt : this.vector.size();
    }

    @Override
    public int rowSize() {
        return this.asCol ? this.vector.size() : this.replicationCnt;
    }

    @Override
    public Matrix divide(double x) {
        return new ReplicatedVectorMatrix(this.vector.divide(x), this.replicationCnt, this.asCol);
    }

    @Override
    public double get(int row, int col) {
        return this.asCol ? this.vector.get(row) : this.vector.get(col);
    }

    @Override
    public double getX(int row, int col) {
        return this.asCol ? this.vector.getX(row) : this.vector.getX(col);
    }

    @Override
    public MatrixStorage getStorage() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Matrix copy() {
        Vector cp = this.vector.copy();
        return new ReplicatedVectorMatrix(cp, this.replicationCnt, this.asCol);
    }

    @Override
    public Matrix like(int rows, int cols) {
        Vector lk = this.vector.like(this.vector.size());
        return new ReplicatedVectorMatrix(lk, this.replicationCnt, this.asCol);
    }

    @Override
    public Vector likeVector(int crd) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Matrix minus(Matrix mtx) {
        throw new UnsupportedOperationException();
    }

    public Matrix minus(ReplicatedVectorMatrix mtx) {
        if (this.isColumnReplicated() == mtx.isColumnReplicated()) {
            this.checkCardinality(mtx.rowSize(), mtx.columnSize());
            Vector minus = this.vector.minus(mtx.replicant());
            return new ReplicatedVectorMatrix(minus, this.replicationCnt, this.asCol);
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public Matrix plus(double x) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Matrix plus(Matrix mtx) {
        throw new UnsupportedOperationException();
    }

    public Matrix plus(ReplicatedVectorMatrix mtx) {
        if (this.isColumnReplicated() == mtx.isColumnReplicated()) {
            this.checkCardinality(mtx.rowSize(), mtx.columnSize());
            Vector plus = this.vector.plus(mtx.replicant());
            return new ReplicatedVectorMatrix(plus, this.replicationCnt, this.asCol);
        }
        throw new UnsupportedOperationException();
    }

    private void checkCardinality(int rows, int cols) {
        if (rows != this.rowSize()) {
            throw new CardinalityException(this.rowSize(), rows);
        }
        if (cols != this.columnSize()) {
            throw new CardinalityException(this.columnSize(), cols);
        }
    }

    @Override
    public IgniteUuid guid() {
        return null;
    }

    @Override
    public Matrix set(int row, int col, double val) {
        this.vector.set(this.asCol ? row : col, val);
        return this;
    }

    @Override
    public Matrix setRow(int row, double[] data) {
        return null;
    }

    @Override
    public Vector getRow(int row) {
        return null;
    }

    @Override
    public Matrix setColumn(int col, double[] data) {
        return null;
    }

    @Override
    public Vector getCol(int col) {
        return null;
    }

    @Override
    public Matrix setX(int row, int col, double val) {
        return null;
    }

    @Override
    public Matrix times(double x) {
        return new ReplicatedVectorMatrix(this.vector.times(x), this.replicationCnt, this.asCol);
    }

    @Override
    public Matrix times(Matrix mtx) {
        if (!this.asCol) {
            Vector row = this.vector.like(mtx.columnSize());
            for (int i = 0; i < mtx.columnSize(); ++i) {
                row.setX(i, this.vector.dot(mtx.getCol(i)));
            }
            return new ReplicatedVectorMatrix(row, this.replicationCnt, false);
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public Vector times(Vector vec) {
        Vector res = vec.like(vec.size());
        if (this.asCol) {
            for (int i = 0; i < this.rowSize(); ++i) {
                res.setX(i, vec.sum() * this.vector.getX(i));
            }
        } else {
            double val = this.vector.dot(vec);
            for (int i = 0; i < this.rowSize(); ++i) {
                res.setX(i, val);
            }
        }
        return res;
    }

    @Override
    public double sum() {
        return this.vector.sum() * (double)this.replicationCnt;
    }

    @Override
    public Matrix transpose() {
        return new ReplicatedVectorMatrix(this.vector, this.replicationCnt, !this.asCol);
    }

    @Override
    public Vector viewRow(int row) {
        return null;
    }

    @Override
    public Vector viewColumn(int col) {
        return null;
    }

    @Override
    public Vector viewDiagonal() {
        return null;
    }

    @Override
    public void compute(int row, int col, IgniteTriFunction<Integer, Integer, Double, Double> f) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Map<String, Object> getMetaStorage() {
        return null;
    }

    public boolean isColumnReplicated() {
        return this.asCol;
    }

    public Vector replicant() {
        return this.vector;
    }
}

