/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.ml.math.primitives.vector.storage;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.ignite.ml.math.exceptions.IndexException;
import org.apache.ignite.ml.math.primitives.matrix.Matrix;
import org.apache.ignite.ml.math.primitives.vector.VectorStorage;

public class VectorizedViewMatrixStorage
implements VectorStorage {
    private Matrix parent;
    private int row;
    private int col;
    private int rowStride;
    private int colStride;
    private int size;

    public VectorizedViewMatrixStorage() {
    }

    public VectorizedViewMatrixStorage(Matrix parent, int row, int col, int rowStride, int colStride) {
        assert (parent != null);
        assert (rowStride >= 0);
        assert (colStride >= 0);
        assert (rowStride > 0 || colStride > 0);
        if (row < 0 || row >= parent.rowSize()) {
            throw new IndexException(row);
        }
        if (col < 0 || col >= parent.columnSize()) {
            throw new IndexException(col);
        }
        this.parent = parent;
        this.row = row;
        this.col = col;
        this.rowStride = rowStride;
        this.colStride = colStride;
        this.size = this.getSize();
    }

    int row() {
        return this.row;
    }

    int column() {
        return this.col;
    }

    int rowStride() {
        return this.rowStride;
    }

    int columnStride() {
        return this.colStride;
    }

    private int getSize() {
        if (this.rowStride != 0 && this.colStride != 0) {
            int n1 = (this.parent.rowSize() - this.row) / this.rowStride;
            int n2 = (this.parent.columnSize() - this.col) / this.colStride;
            return Math.min(n1, n2);
        }
        if (this.rowStride > 0) {
            return (this.parent.rowSize() - this.row) / this.rowStride;
        }
        return (this.parent.columnSize() - this.col) / this.colStride;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public double get(int i) {
        return this.parent.get(this.row + i * this.rowStride, this.col + i * this.colStride);
    }

    @Override
    public void set(int i, double v) {
        this.parent.set(this.row + i * this.rowStride, this.col + i * this.colStride, v);
    }

    @Override
    public boolean isSequentialAccess() {
        return this.parent.isSequentialAccess();
    }

    @Override
    public boolean isDense() {
        return this.parent.isDense();
    }

    @Override
    public boolean isRandomAccess() {
        return this.parent.isRandomAccess();
    }

    @Override
    public boolean isDistributed() {
        return this.parent.isDistributed();
    }

    @Override
    public boolean isArrayBased() {
        return false;
    }

    @Override
    public double[] data() {
        double[] res = new double[this.size];
        for (int i = 0; i < this.size; ++i) {
            res[i] = this.get(i);
        }
        return res;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.parent);
        out.writeInt(this.row);
        out.writeInt(this.col);
        out.writeInt(this.rowStride);
        out.writeInt(this.colStride);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.parent = (Matrix)in.readObject();
        this.row = in.readInt();
        this.col = in.readInt();
        this.rowStride = in.readInt();
        this.colStride = in.readInt();
        this.size = this.getSize();
    }
}

