/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.ml.math.primitives.vector.storage;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Arrays;
import org.apache.ignite.ml.math.primitives.vector.VectorStorage;

public class DenseVectorStorage
implements VectorStorage {
    private double[] data;

    public DenseVectorStorage() {
    }

    public DenseVectorStorage(int size) {
        assert (size > 0);
        this.data = new double[size];
    }

    public DenseVectorStorage(double[] data) {
        assert (data != null);
        this.data = data;
    }

    @Override
    public int size() {
        return this.data == null ? 0 : this.data.length;
    }

    @Override
    public double get(int i) {
        return this.data[i];
    }

    @Override
    public void set(int i, double v) {
        this.data[i] = v;
    }

    @Override
    public boolean isArrayBased() {
        return true;
    }

    @Override
    public double[] data() {
        return this.data;
    }

    @Override
    public boolean isSequentialAccess() {
        return true;
    }

    @Override
    public boolean isDense() {
        return true;
    }

    @Override
    public boolean isRandomAccess() {
        return true;
    }

    @Override
    public boolean isDistributed() {
        return false;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.data);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.data = (double[])in.readObject();
    }

    public int hashCode() {
        int res = 1;
        res = res * 37 + Arrays.hashCode(this.data);
        return res;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        DenseVectorStorage that = (DenseVectorStorage)obj;
        return Arrays.equals(this.data, that.data);
    }
}

