/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.ml.math.primitives.matrix.impl;

import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntSet;
import org.apache.ignite.ml.math.StorageConstants;
import org.apache.ignite.ml.math.functions.IgniteTriFunction;
import org.apache.ignite.ml.math.primitives.matrix.AbstractMatrix;
import org.apache.ignite.ml.math.primitives.matrix.Matrix;
import org.apache.ignite.ml.math.primitives.matrix.MatrixStorage;
import org.apache.ignite.ml.math.primitives.matrix.storage.SparseMatrixStorage;
import org.apache.ignite.ml.math.primitives.vector.Vector;
import org.apache.ignite.ml.math.primitives.vector.impl.SparseVector;

public class SparseMatrix
extends AbstractMatrix
implements StorageConstants {
    public SparseMatrix() {
    }

    public SparseMatrix(int rows, int cols) {
        this.setStorage(this.mkStorage(rows, cols));
    }

    private MatrixStorage mkStorage(int rows, int cols) {
        return new SparseMatrixStorage(rows, cols, 1002, 2001);
    }

    @Override
    public Matrix like(int rows, int cols) {
        return new SparseMatrix(rows, cols);
    }

    @Override
    public Vector likeVector(int crd) {
        return new SparseVector(crd, 1002);
    }

    @Override
    public int nonZeroElements() {
        int res = 0;
        IntIterator rowIter = this.indexesMap().keySet().iterator();
        while (rowIter.hasNext()) {
            int row = rowIter.nextInt();
            res += ((IntSet)this.indexesMap().get(row)).size();
        }
        return res;
    }

    public Int2ObjectArrayMap<IntSet> indexesMap() {
        return ((SparseMatrixStorage)this.getStorage()).indexesMap();
    }

    @Override
    public Matrix copy() {
        Matrix cp = this.like(this.rowSize(), this.columnSize());
        cp.assign(this);
        return cp;
    }

    @Override
    public void compute(int row, int col, IgniteTriFunction<Integer, Integer, Double, Double> f) {
        ((SparseMatrixStorage)this.getStorage()).compute(row, col, f);
    }
}

