/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.ml.math;

import java.awt.Color;
import java.awt.Desktop;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.Locale;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.lang.IgniteUuid;
import org.apache.ignite.ml.math.primitives.matrix.Matrix;
import org.apache.ignite.ml.math.primitives.vector.Vector;

public class Tracer {
    private static final Locale LOCALE = Locale.US;

    private static ColorMapper defaultColorMapper(final double min, double max) {
        final double range = max - min;
        return new ColorMapper(){

            @Override
            public Color apply(Double d) {
                d = (d - min) / range;
                int r = (int)Math.round(255.0 * d);
                int g = 0;
                int b = (int)Math.round(255.0 * (1.0 - d));
                return new Color(r, g, b);
            }
        };
    }

    private static ColorMapper mkVectorColorMapper(Vector vec) {
        return Tracer.defaultColorMapper(vec.minValue(), vec.maxValue());
    }

    private static ColorMapper mkMatrixColorMapper(Matrix mtx) {
        return Tracer.defaultColorMapper(mtx.minValue(), mtx.maxValue());
    }

    public static void showAscii(Vector vec, IgniteLogger log, String fmt) {
        String cls = vec.getClass().getSimpleName();
        log.info(String.format(LOCALE, "%s(%d) [%s]", cls, vec.size(), Tracer.mkString(vec, fmt)));
    }

    public static void showAscii(Vector vec, IgniteLogger log) {
        Tracer.showAscii(vec, log, "%4f");
    }

    public static void showAscii(Vector vec, String fmt) {
        String cls = vec.getClass().getSimpleName();
        System.out.println(Tracer.asAscii(vec, fmt, true));
    }

    public static String asAscii(Vector vec, String fmt, boolean showMeta) {
        String cls = vec.getClass().getSimpleName();
        String vectorStr = Tracer.mkString(vec, fmt);
        if (showMeta) {
            return String.format(LOCALE, "%s(%d) [%s]", cls, vec.size(), vectorStr);
        }
        return String.format(LOCALE, "[%s]", vectorStr);
    }

    public static void showAscii(Matrix mtx) {
        Tracer.showAscii(mtx, "%4f");
    }

    private static String rowStr(Matrix mtx, int row, String fmt) {
        StringBuilder buf = new StringBuilder();
        boolean first = true;
        int cols = mtx.columnSize();
        for (int col = 0; col < cols; ++col) {
            String s = String.format(LOCALE, fmt, mtx.get(row, col));
            if (!first) {
                buf.append(", ");
            }
            buf.append(s);
            first = false;
        }
        return buf.toString();
    }

    public static void showAscii(Matrix mtx, String fmt) {
        System.out.println(Tracer.asAscii(mtx, fmt));
    }

    public static String asAscii(Matrix mtx, String fmt) {
        StringBuilder builder = new StringBuilder();
        String cls = mtx.getClass().getSimpleName();
        int rows = mtx.rowSize();
        int cols = mtx.columnSize();
        builder.append(String.format(LOCALE, "%s(%dx%d)\n", cls, rows, cols));
        for (int row = 0; row < rows; ++row) {
            builder.append(Tracer.rowStr(mtx, row, fmt)).append(row != rows - 1 ? "\n" : "");
        }
        return builder.toString();
    }

    public static void showAscii(Matrix mtx, IgniteLogger log, String fmt) {
        String cls = mtx.getClass().getSimpleName();
        int rows = mtx.rowSize();
        int cols = mtx.columnSize();
        log.info(String.format(LOCALE, "%s(%dx%d)", cls, rows, cols));
        for (int row = 0; row < rows; ++row) {
            log.info(Tracer.rowStr(mtx, row, fmt));
        }
    }

    public static void showAscii(Vector vec) {
        Tracer.showAscii(vec, "%4f");
    }

    public static void saveAsCsv(Vector vec, String fmt, String filePath) throws IOException {
        String s = Tracer.mkString(vec, fmt);
        Files.write(Paths.get(filePath, new String[0]), s.getBytes(), StandardOpenOption.CREATE, StandardOpenOption.WRITE);
    }

    public static void saveAsCsv(Matrix mtx, String fmt, String filePath) throws IOException {
        String s = Tracer.mkString(mtx, fmt);
        Files.write(Paths.get(filePath, new String[0]), s.getBytes(), StandardOpenOption.CREATE, StandardOpenOption.WRITE);
    }

    public static void showHtml(Matrix mtx) throws IOException {
        Tracer.showHtml(mtx, false);
    }

    public static void showHtml(Matrix mtx, boolean useAsciiFallback) throws IOException {
        Tracer.showHtml(mtx, Tracer.mkMatrixColorMapper(mtx), useAsciiFallback);
    }

    public static void showHtml(Matrix mtx, ColorMapper cm) throws IOException {
        Tracer.showHtml(mtx, cm, false);
    }

    public static void showHtml(Matrix mtx, ColorMapper cm, boolean useAsciiFallback) throws IOException {
        if (!Tracer.isBrowseSupported() && useAsciiFallback) {
            Tracer.showAscii(mtx);
        } else {
            String tmpl = Tracer.fileToString("d3-matrix-template.html");
            String cls = mtx.getClass().getSimpleName();
            double min = mtx.minValue();
            double max = mtx.maxValue();
            Tracer.openHtmlFile(tmpl.replaceAll("/\\*@NAME@\\*/.*\n", "var name = \"" + cls + "\";\n").replaceAll("/\\*@MIN@\\*/.*\n", "var min = " + Tracer.dataColorJson(min, (Color)cm.apply(min)) + ";\n").replaceAll("/\\*@MAX@\\*/.*\n", "var max = " + Tracer.dataColorJson(max, (Color)cm.apply(max)) + ";\n").replaceAll("/\\*@DATA@\\*/.*\n", "var data = " + Tracer.mkJsArrayString(mtx, cm) + ";\n"));
        }
    }

    public static void showHtml(Vector vec) throws IOException {
        Tracer.showHtml(vec, false);
    }

    public static void showHtml(Vector vec, boolean useAsciiFallback) throws IOException {
        Tracer.showHtml(vec, Tracer.mkVectorColorMapper(vec), useAsciiFallback);
    }

    private static String dataColorJson(double d, Color clr) {
        return "{d: " + String.format(LOCALE, "%4f", d) + ", r: " + clr.getRed() + ", g: " + clr.getGreen() + ", b: " + clr.getBlue() + "}";
    }

    public static void showHtml(Vector vec, ColorMapper cm) throws IOException {
        Tracer.showHtml(vec, cm, false);
    }

    public static void showHtml(Vector vec, ColorMapper cm, boolean useAsciiFallback) throws IOException {
        if (!Tracer.isBrowseSupported() && useAsciiFallback) {
            Tracer.showAscii(vec);
        } else {
            String tmpl = Tracer.fileToString("d3-vector-template.html");
            String cls = vec.getClass().getSimpleName();
            double min = vec.minValue();
            double max = vec.maxValue();
            Tracer.openHtmlFile(tmpl.replaceAll("/\\*@NAME@\\*/.*\n", "var name = \"" + cls + "\";\n").replaceAll("/\\*@MIN@\\*/.*\n", "var min = " + Tracer.dataColorJson(min, (Color)cm.apply(min)) + ";\n").replaceAll("/\\*@MAX@\\*/.*\n", "var max = " + Tracer.dataColorJson(max, (Color)cm.apply(max)) + ";\n").replaceAll("/\\*@DATA@\\*/.*\n", "var data = " + Tracer.mkJsArrayString(vec, cm) + ";\n"));
        }
    }

    private static boolean isBrowseSupported() {
        return Desktop.isDesktopSupported() && Desktop.getDesktop().isSupported(Desktop.Action.BROWSE);
    }

    private static String fileToString(String fileName) throws IOException {
        assert (Tracer.class.getResourceAsStream(fileName) != null) : "Can't get resource: " + fileName;
        try (InputStreamReader is = new InputStreamReader(Tracer.class.getResourceAsStream(fileName), StandardCharsets.US_ASCII);){
            String string = new BufferedReader(is).lines().collect(Collectors.joining("\n"));
            return string;
        }
    }

    private static void openHtmlFile(String html) throws IOException {
        File temp = File.createTempFile(IgniteUuid.randomUuid().toString(), ".html");
        BufferedWriter bw = new BufferedWriter(new FileWriter(temp));
        bw.write(html);
        bw.close();
        Desktop.getDesktop().browse(temp.toURI());
    }

    private static String mkString(Vector vec, String fmt) {
        boolean first = true;
        StringBuilder buf = new StringBuilder();
        for (Vector.Element x : vec.all()) {
            String s = String.format(LOCALE, fmt, x.get());
            if (!first) {
                buf.append(", ");
                buf.append(s);
                continue;
            }
            buf.append(s);
            first = false;
        }
        return buf.toString();
    }

    private static String mkJsArrayString(Vector vec, ColorMapper cm) {
        boolean first = true;
        StringBuilder buf = new StringBuilder();
        for (Vector.Element x : vec.all()) {
            double d = x.get();
            String s = Tracer.dataColorJson(d, (Color)cm.apply(d));
            if (!first) {
                buf.append(", ");
            }
            buf.append(s);
            first = false;
        }
        return '[' + buf.toString() + ']';
    }

    private static String mkJsArrayString(Matrix mtx, ColorMapper cm) {
        boolean first = true;
        StringBuilder buf = new StringBuilder();
        int rows = mtx.rowSize();
        int cols = mtx.columnSize();
        for (int row = 0; row < rows; ++row) {
            StringBuilder rowBuf = new StringBuilder();
            boolean rowFirst = true;
            for (int col = 0; col < cols; ++col) {
                double d = mtx.get(row, col);
                String s = Tracer.dataColorJson(d, (Color)cm.apply(d));
                if (!rowFirst) {
                    rowBuf.append(", ");
                }
                rowBuf.append(s);
                rowFirst = false;
            }
            if (!first) {
                buf.append(", ");
            }
            buf.append('[').append(rowBuf.toString()).append(']');
            first = false;
        }
        return '[' + buf.toString() + ']';
    }

    private static String mkString(Matrix mtx, String fmt) {
        StringBuilder buf = new StringBuilder();
        int rows = mtx.rowSize();
        int cols = mtx.columnSize();
        for (int row = 0; row < rows; ++row) {
            for (int col = 0; col < cols; ++col) {
                String s = String.format(LOCALE, fmt, mtx.get(row, col));
                if (col != 0) {
                    buf.append(", ");
                }
                buf.append(s);
                if (col != cols - 1 || row == rows - 1) continue;
                buf.append(",\n");
            }
        }
        return buf.toString();
    }

    public static interface ColorMapper
    extends Function<Double, Color> {
    }
}

