/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.ml.knn;

import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.ignite.ml.Exportable;
import org.apache.ignite.ml.Exporter;
import org.apache.ignite.ml.Model;
import org.apache.ignite.ml.knn.classification.KNNModelFormat;
import org.apache.ignite.ml.knn.classification.NNStrategy;
import org.apache.ignite.ml.math.distances.DistanceMeasure;
import org.apache.ignite.ml.math.distances.EuclideanDistance;
import org.apache.ignite.ml.math.primitives.vector.Vector;
import org.apache.ignite.ml.structures.LabeledVector;
import org.apache.ignite.ml.structures.LabeledVectorSet;
import org.apache.ignite.ml.util.ModelTrace;
import org.jetbrains.annotations.NotNull;

public abstract class NNClassificationModel
implements Model<Vector, Double>,
Exportable<KNNModelFormat> {
    protected int k = 5;
    protected DistanceMeasure distanceMeasure = new EuclideanDistance();
    protected NNStrategy stgy = NNStrategy.SIMPLE;

    public NNClassificationModel withK(int k) {
        this.k = k;
        return this;
    }

    public NNClassificationModel withStrategy(NNStrategy stgy) {
        this.stgy = stgy;
        return this;
    }

    public NNClassificationModel withDistanceMeasure(DistanceMeasure distanceMeasure) {
        this.distanceMeasure = distanceMeasure;
        return this;
    }

    protected LabeledVectorSet<Double, LabeledVector> buildLabeledDatasetOnListOfVectors(List<LabeledVector> neighborsFromPartitions) {
        LabeledVector[] arr = new LabeledVector[neighborsFromPartitions.size()];
        for (int i = 0; i < arr.length; ++i) {
            arr[i] = neighborsFromPartitions.get(i);
        }
        return new LabeledVectorSet(arr);
    }

    @NotNull
    protected LabeledVector[] getKClosestVectors(LabeledVectorSet<Double, LabeledVector> trainingData, TreeMap<Double, Set<Integer>> distanceIdxPairs) {
        LabeledVector[] res;
        if (trainingData.rowSize() <= this.k) {
            res = new LabeledVector[trainingData.rowSize()];
            for (int i = 0; i < trainingData.rowSize(); ++i) {
                res[i] = (LabeledVector)trainingData.getRow(i);
            }
        } else {
            res = new LabeledVector[this.k];
            int i = 0;
            Iterator<Double> iter = distanceIdxPairs.keySet().iterator();
            block1: while (i < this.k) {
                double key = iter.next();
                Set<Integer> idxs = distanceIdxPairs.get(key);
                for (Integer idx : idxs) {
                    res[i] = (LabeledVector)trainingData.getRow(idx);
                    if (++i < this.k) continue;
                    continue block1;
                }
            }
        }
        return res;
    }

    @NotNull
    protected TreeMap<Double, Set<Integer>> getDistances(Vector v, LabeledVectorSet<Double, LabeledVector> trainingData) {
        TreeMap<Double, Set<Integer>> distanceIdxPairs = new TreeMap<Double, Set<Integer>>();
        for (int i = 0; i < trainingData.rowSize(); ++i) {
            LabeledVector labeledVector = (LabeledVector)trainingData.getRow(i);
            if (labeledVector == null) continue;
            double distance = this.distanceMeasure.compute(v, (Vector)labeledVector.features());
            this.putDistanceIdxPair(distanceIdxPairs, i, distance);
        }
        return distanceIdxPairs;
    }

    protected void putDistanceIdxPair(Map<Double, Set<Integer>> distanceIdxPairs, int i, double distance) {
        if (distanceIdxPairs.containsKey(distance)) {
            Set<Integer> idxs = distanceIdxPairs.get(distance);
            idxs.add(i);
        } else {
            HashSet<Integer> idxs = new HashSet<Integer>();
            idxs.add(i);
            distanceIdxPairs.put(distance, idxs);
        }
    }

    protected double getClassWithMaxVotes(Map<Double, Double> clsVotes) {
        return (Double)Collections.max(clsVotes.entrySet(), Map.Entry.comparingByValue()).getKey();
    }

    protected double getClassVoteForVector(NNStrategy stgy, double distance) {
        if (stgy.equals((Object)NNStrategy.WEIGHTED)) {
            return 1.0 / distance;
        }
        return 1.0;
    }

    public DistanceMeasure getDistanceMeasure() {
        return this.distanceMeasure;
    }

    public int hashCode() {
        int res = 1;
        res = res * 37 + this.k;
        res = res * 37 + this.distanceMeasure.hashCode();
        res = res * 37 + this.stgy.hashCode();
        return res;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        NNClassificationModel that = (NNClassificationModel)obj;
        return this.k == that.k && this.distanceMeasure.equals(that.distanceMeasure) && this.stgy.equals((Object)that.stgy);
    }

    public String toString() {
        return this.toString(false);
    }

    @Override
    public String toString(boolean pretty) {
        return ModelTrace.builder("KNNClassificationModel", pretty).addField("k", String.valueOf(this.k)).addField("measure", this.distanceMeasure.getClass().getSimpleName()).addField("strategy", this.stgy.name()).toString();
    }

    protected void copyParametersFrom(NNClassificationModel mdl) {
        this.k = mdl.k;
        this.distanceMeasure = mdl.distanceMeasure;
        this.stgy = mdl.stgy;
    }

    @Override
    public abstract <P> void saveModel(Exporter<KNNModelFormat, P> var1, P var2);
}

