/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.ml.genetic;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.cache.Cache;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.IgniteException;
import org.apache.ignite.cache.affinity.Affinity;
import org.apache.ignite.cache.query.Query;
import org.apache.ignite.cache.query.QueryCursor;
import org.apache.ignite.cache.query.SqlQuery;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.compute.ComputeJobResult;
import org.apache.ignite.compute.ComputeJobResultPolicy;
import org.apache.ignite.compute.ComputeTaskAdapter;
import org.apache.ignite.ml.genetic.Gene;
import org.apache.ignite.ml.genetic.MutateJob;
import org.apache.ignite.ml.genetic.parameter.GAConfiguration;
import org.apache.ignite.resources.IgniteInstanceResource;

public class MutateTask
extends ComputeTaskAdapter<List<Long>, Boolean> {
    @IgniteInstanceResource
    private Ignite ignite = null;
    private GAConfiguration cfg;

    public MutateTask(GAConfiguration cfg) {
        this.cfg = cfg;
    }

    private List<Long> getMutatedGenes() {
        ArrayList<Long> mutatedGenes = new ArrayList<Long>();
        this.cfg.getChromosomeLen();
        for (int i = 0; i < this.cfg.getChromosomeLen(); ++i) {
            mutatedGenes.add(this.selectGene(i));
        }
        return mutatedGenes;
    }

    public Map map(List<ClusterNode> nodes, List<Long> chromosomeKeys) throws IgniteException {
        HashMap<MutateJob, ClusterNode> map = new HashMap<MutateJob, ClusterNode>();
        Affinity affinity = this.ignite.affinity("populationCache");
        for (Long key : chromosomeKeys) {
            MutateJob ajob = new MutateJob(key, this.getMutatedGenes(), this.cfg.getMutationRate());
            ClusterNode primary = affinity.mapKeyToNode((Object)key);
            map.put(ajob, primary);
        }
        return map;
    }

    public Boolean reduce(List<ComputeJobResult> list) throws IgniteException {
        return Boolean.TRUE;
    }

    public ComputeJobResultPolicy result(ComputeJobResult res, List<ComputeJobResult> rcvd) {
        IgniteException err = res.getException();
        if (err != null) {
            return ComputeJobResultPolicy.FAILOVER;
        }
        return ComputeJobResultPolicy.WAIT;
    }

    private long selectAnyGene() {
        int idx = this.selectRandomIndex(this.cfg.getGenePool().size());
        Gene gene = this.cfg.getGenePool().get(idx);
        return gene.id();
    }

    private long selectGene(int k) {
        if (this.cfg.getChromosomeCriteria() == null) {
            return this.selectAnyGene();
        }
        return this.selectGeneByChromsomeCriteria(k);
    }

    private long selectGeneByChromsomeCriteria(int k) {
        ArrayList<Object> genes = new ArrayList<Object>();
        StringBuffer sbSqlClause = new StringBuffer("_val like '");
        sbSqlClause.append("%");
        sbSqlClause.append(this.cfg.getChromosomeCriteria().getCriteria().get(k));
        sbSqlClause.append("%'");
        IgniteCache cache = this.ignite.cache("geneCache");
        SqlQuery sql = new SqlQuery(Gene.class, sbSqlClause.toString());
        try (QueryCursor cursor = cache.query((Query)sql);){
            for (Cache.Entry e : cursor) {
                genes.add(e.getValue());
            }
        }
        int idx = this.selectRandomIndex(genes.size());
        Gene gene = (Gene)genes.get(idx);
        return gene.id();
    }

    private int selectRandomIndex(int sizeOfGenePool) {
        Random randomGenerator = new Random();
        return randomGenerator.nextInt(sizeOfGenePool);
    }
}

