/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.ml.dataset.primitive.builder.data;

import java.io.Serializable;
import java.util.Iterator;
import org.apache.ignite.ml.dataset.PartitionDataBuilder;
import org.apache.ignite.ml.dataset.UpstreamEntry;
import org.apache.ignite.ml.dataset.primitive.data.SimpleDatasetData;
import org.apache.ignite.ml.math.functions.IgniteBiFunction;
import org.apache.ignite.ml.math.primitives.vector.Vector;

public class SimpleDatasetDataBuilder<K, V, C extends Serializable>
implements PartitionDataBuilder<K, V, C, SimpleDatasetData> {
    private static final long serialVersionUID = 756800193212149975L;
    private final IgniteBiFunction<K, V, Vector> featureExtractor;

    public SimpleDatasetDataBuilder(IgniteBiFunction<K, V, Vector> featureExtractor) {
        this.featureExtractor = featureExtractor;
    }

    @Override
    public SimpleDatasetData build(Iterator<UpstreamEntry<K, V>> upstreamData, long upstreamDataSize, C ctx) {
        int cols = -1;
        double[] features = null;
        int ptr = 0;
        while (upstreamData.hasNext()) {
            UpstreamEntry<K, V> entry = upstreamData.next();
            Vector row = (Vector)this.featureExtractor.apply(entry.getKey(), entry.getValue());
            if (cols < 0) {
                cols = row.size();
                features = new double[Math.toIntExact(upstreamDataSize * (long)cols)];
            } else assert (row.size() == cols) : "Feature extractor must return exactly " + cols + " features";
            for (int i = 0; i < cols; ++i) {
                features[Math.toIntExact((long)((long)i * upstreamDataSize + (long)ptr))] = row.get(i);
            }
            ++ptr;
        }
        return new SimpleDatasetData(features, Math.toIntExact(upstreamDataSize));
    }
}

