/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.ml.dataset.impl.bootstrapping;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Arrays;
import org.apache.ignite.ml.math.primitives.vector.Vector;
import org.apache.ignite.ml.structures.LabeledVector;

public class BootstrappedVector
extends LabeledVector<Vector, Double> {
    private static final long serialVersionUID = -4583008673032917259L;
    private int[] counters;

    public BootstrappedVector(Vector features, double lb, int[] counters) {
        super(features, lb);
        this.counters = counters;
    }

    public int[] counters() {
        return this.counters;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        BootstrappedVector vector = (BootstrappedVector)o;
        return Arrays.equals(this.counters, vector.counters);
    }

    @Override
    public int hashCode() {
        int res = super.hashCode();
        res = 31 * res + Arrays.hashCode(this.counters);
        return res;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeObject(this.counters);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.counters = (int[])in.readObject();
    }
}

