/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.ml.dataset;

import java.io.Serializable;
import org.apache.ignite.ml.math.functions.IgniteBiConsumer;
import org.apache.ignite.ml.math.functions.IgniteBiFunction;
import org.apache.ignite.ml.math.functions.IgniteBinaryOperator;
import org.apache.ignite.ml.math.functions.IgniteConsumer;
import org.apache.ignite.ml.math.functions.IgniteFunction;
import org.apache.ignite.ml.math.functions.IgniteTriConsumer;
import org.apache.ignite.ml.math.functions.IgniteTriFunction;

public interface Dataset<C extends Serializable, D extends AutoCloseable>
extends AutoCloseable {
    public <R> R computeWithCtx(IgniteTriFunction<C, D, Integer, R> var1, IgniteBinaryOperator<R> var2, R var3);

    public <R> R compute(IgniteBiFunction<D, Integer, R> var1, IgniteBinaryOperator<R> var2, R var3);

    default public <R> R computeWithCtx(IgniteTriFunction<C, D, Integer, R> map, IgniteBinaryOperator<R> reduce) {
        return this.computeWithCtx(map, reduce, null);
    }

    default public <R> R compute(IgniteBiFunction<D, Integer, R> map, IgniteBinaryOperator<R> reduce) {
        return this.compute(map, reduce, null);
    }

    default public <R> R computeWithCtx(IgniteBiFunction<C, D, R> map, IgniteBinaryOperator<R> reduce, R identity) {
        return (R)this.computeWithCtx((C ctx, D data, Integer partIdx) -> map.apply(ctx, data), reduce, identity);
    }

    default public <R> R compute(IgniteFunction<D, R> map, IgniteBinaryOperator<R> reduce, R identity) {
        return this.compute((data, partIdx) -> map.apply(data), reduce, identity);
    }

    default public <R> R computeWithCtx(IgniteBiFunction<C, D, R> map, IgniteBinaryOperator<R> reduce) {
        return (R)this.computeWithCtx((C ctx, D data, Integer partIdx) -> map.apply(ctx, data), reduce);
    }

    default public <R> R compute(IgniteFunction<D, R> map, IgniteBinaryOperator<R> reduce) {
        return this.compute((data, partIdx) -> map.apply(data), reduce);
    }

    default public void computeWithCtx(IgniteTriConsumer<C, D, Integer> map) {
        this.computeWithCtx((C ctx, D data, Integer partIdx) -> {
            map.accept((Object)ctx, (Object)data, (Integer)partIdx);
            return null;
        }, (a, b) -> null);
    }

    default public void compute(IgniteBiConsumer<D, Integer> map) {
        this.compute((data, partIdx) -> {
            map.accept((Object)data, (Integer)partIdx);
            return null;
        }, (a, b) -> null);
    }

    default public void computeWithCtx(IgniteBiConsumer<C, D> map) {
        this.computeWithCtx((C ctx, D data, Integer partIdx) -> map.accept(ctx, data));
    }

    default public void compute(IgniteConsumer<D> map) {
        this.compute((data, partIdx) -> map.accept(data));
    }

    default public <I extends Dataset<C, D>> I wrap(IgniteFunction<Dataset<C, D>, I> wrapper) {
        return (I)((Dataset)wrapper.apply(this));
    }
}

