/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.ml;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.ml.Exporter;

public class FileExporter<D>
implements Exporter<D, String> {
    private IgniteLogger log = null;

    public void setLog(IgniteLogger log) {
        this.log = log;
    }

    @Override
    public void save(D d, String path) {
        block26: {
            try (FileOutputStream fos = new FileOutputStream(path);
                 ObjectOutputStream outStream = new ObjectOutputStream(fos);){
                outStream.writeObject(d);
            }
            catch (IOException e) {
                if (this.log == null) break block26;
                this.log.error("Error opening file.", (Throwable)e);
            }
        }
    }

    @Override
    public D load(String path) {
        Object mdl;
        block29: {
            mdl = null;
            try (FileInputStream fis = new FileInputStream(path);){
                try (ObjectInputStream inputStream = new ObjectInputStream(fis);){
                    mdl = inputStream.readObject();
                }
                catch (ClassNotFoundException e) {
                    if (this.log != null) {
                        this.log.error("Object creation failed.", (Throwable)e);
                    }
                }
            }
            catch (IOException e) {
                if (this.log == null) break block29;
                this.log.error("Error opening file.", (Throwable)e);
            }
        }
        return (D)mdl;
    }
}

