/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.orc;

import java.math.BigDecimal;
import org.apache.orc.storage.ql.exec.vector.BytesColumnVector;
import org.apache.orc.storage.ql.exec.vector.DecimalColumnVector;
import org.apache.orc.storage.ql.exec.vector.DoubleColumnVector;
import org.apache.orc.storage.ql.exec.vector.LongColumnVector;
import org.apache.orc.storage.ql.exec.vector.TimestampColumnVector;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.Decimal;
import org.apache.spark.sql.types.TimestampType;
import org.apache.spark.sql.vectorized.ColumnVector;
import org.apache.spark.sql.vectorized.ColumnarArray;
import org.apache.spark.sql.vectorized.ColumnarMap;
import org.apache.spark.unsafe.types.UTF8String;

public class OrcColumnVector
extends ColumnVector {
    private org.apache.orc.storage.ql.exec.vector.ColumnVector baseData;
    private LongColumnVector longData;
    private DoubleColumnVector doubleData;
    private BytesColumnVector bytesData;
    private DecimalColumnVector decimalData;
    private TimestampColumnVector timestampData;
    private final boolean isTimestamp;
    private int batchSize;

    OrcColumnVector(DataType type, org.apache.orc.storage.ql.exec.vector.ColumnVector vector) {
        super(type);
        this.isTimestamp = type instanceof TimestampType;
        this.baseData = vector;
        if (vector instanceof LongColumnVector) {
            this.longData = (LongColumnVector)vector;
        } else if (vector instanceof DoubleColumnVector) {
            this.doubleData = (DoubleColumnVector)vector;
        } else if (vector instanceof BytesColumnVector) {
            this.bytesData = (BytesColumnVector)vector;
        } else if (vector instanceof DecimalColumnVector) {
            this.decimalData = (DecimalColumnVector)vector;
        } else if (vector instanceof TimestampColumnVector) {
            this.timestampData = (TimestampColumnVector)vector;
        } else {
            throw new UnsupportedOperationException();
        }
    }

    public void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
    }

    @Override
    public void close() {
    }

    @Override
    public boolean hasNull() {
        return !this.baseData.noNulls;
    }

    @Override
    public int numNulls() {
        if (this.baseData.isRepeating) {
            if (this.baseData.isNull[0]) {
                return this.batchSize;
            }
            return 0;
        }
        if (this.baseData.noNulls) {
            return 0;
        }
        int count2 = 0;
        for (int i = 0; i < this.batchSize; ++i) {
            if (!this.baseData.isNull[i]) continue;
            ++count2;
        }
        return count2;
    }

    private int getRowIndex(int rowId) {
        return this.baseData.isRepeating ? 0 : rowId;
    }

    @Override
    public boolean isNullAt(int rowId) {
        return this.baseData.isNull[this.getRowIndex(rowId)];
    }

    @Override
    public boolean getBoolean(int rowId) {
        return this.longData.vector[this.getRowIndex(rowId)] == 1L;
    }

    @Override
    public byte getByte(int rowId) {
        return (byte)this.longData.vector[this.getRowIndex(rowId)];
    }

    @Override
    public short getShort(int rowId) {
        return (short)this.longData.vector[this.getRowIndex(rowId)];
    }

    @Override
    public int getInt(int rowId) {
        return (int)this.longData.vector[this.getRowIndex(rowId)];
    }

    @Override
    public long getLong(int rowId) {
        int index = this.getRowIndex(rowId);
        if (this.isTimestamp) {
            return this.timestampData.time[index] * 1000L + (long)(this.timestampData.nanos[index] / 1000);
        }
        return this.longData.vector[index];
    }

    @Override
    public float getFloat(int rowId) {
        return (float)this.doubleData.vector[this.getRowIndex(rowId)];
    }

    @Override
    public double getDouble(int rowId) {
        return this.doubleData.vector[this.getRowIndex(rowId)];
    }

    @Override
    public Decimal getDecimal(int rowId, int precision, int scale) {
        if (this.isNullAt(rowId)) {
            return null;
        }
        BigDecimal data = this.decimalData.vector[this.getRowIndex(rowId)].getHiveDecimal().bigDecimalValue();
        return Decimal.apply((BigDecimal)data, (int)precision, (int)scale);
    }

    @Override
    public UTF8String getUTF8String(int rowId) {
        if (this.isNullAt(rowId)) {
            return null;
        }
        int index = this.getRowIndex(rowId);
        BytesColumnVector col = this.bytesData;
        return UTF8String.fromBytes((byte[])col.vector[index], (int)col.start[index], (int)col.length[index]);
    }

    @Override
    public byte[] getBinary(int rowId) {
        if (this.isNullAt(rowId)) {
            return null;
        }
        int index = this.getRowIndex(rowId);
        byte[] binary = new byte[this.bytesData.length[index]];
        System.arraycopy(this.bytesData.vector[index], this.bytesData.start[index], binary, 0, binary.length);
        return binary;
    }

    @Override
    public ColumnarArray getArray(int rowId) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ColumnarMap getMap(int rowId) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ColumnVector getChild(int ordinal) {
        throw new UnsupportedOperationException();
    }
}

