/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.spi.deployment.uri;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.compute.ComputeTask;
import org.apache.ignite.internal.util.IgniteUtils;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.spi.IgniteSpiException;
import org.apache.ignite.spi.deployment.uri.GridUriDeploymentClassLoaderFactory;
import org.apache.ignite.spi.deployment.uri.GridUriDeploymentDiscovery;
import org.apache.ignite.spi.deployment.uri.GridUriDeploymentFileProcessorResult;
import org.apache.ignite.spi.deployment.uri.GridUriDeploymentJarVerifier;
import org.apache.ignite.spi.deployment.uri.GridUriDeploymentSpringDocument;
import org.apache.ignite.spi.deployment.uri.GridUriDeploymentSpringParser;
import org.jetbrains.annotations.Nullable;

final class GridUriDeploymentFileProcessor {
    private GridUriDeploymentFileProcessor() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    static GridUriDeploymentFileProcessorResult processFile(File file, String uri, File deployDir, IgniteLogger log) throws IgniteSpiException {
        GridUriDeploymentFileProcessorResult res;
        File gar;
        block12: {
            gar = file;
            if (!GridUriDeploymentFileProcessor.checkIntegrity(file, log)) {
                U.error((IgniteLogger)log, (Object)("Tasks in GAR not loaded in configuration (invalid file signature) [uri=" + U.hidePassword((String)uri) + ']'));
                return null;
            }
            if (!file.isDirectory()) {
                gar = new File(deployDir, "dirzip_" + file.getName());
                gar.mkdirs();
                try {
                    U.unzip((File)file, (File)gar, (IgniteLogger)log);
                }
                catch (IOException e) {
                    throw new IgniteSpiException("IO error when unzipping GAR file: " + file.getAbsolutePath(), (Throwable)e);
                }
            }
            res = null;
            if (gar.isDirectory()) {
                try {
                    File xml = new File(gar, "META-INF/ignite.xml");
                    if (!xml.exists() || xml.isDirectory()) {
                        U.warn((IgniteLogger)log, (Object)("Processing deployment without descriptor file (it will cause full classpath scan) [path=META-INF/ignite.xml, gar=" + gar.getAbsolutePath() + ']'));
                        res = GridUriDeploymentFileProcessor.processNoDescriptorFile(gar, uri, log);
                        break block12;
                    }
                    BufferedInputStream in = null;
                    try {
                        in = new BufferedInputStream(new FileInputStream(xml));
                        GridUriDeploymentSpringDocument doc = GridUriDeploymentSpringParser.parseTasksDocument(in, log);
                        assert (doc != null);
                        res = GridUriDeploymentFileProcessor.processWithDescriptorFile(doc, gar, uri, log);
                    }
                    catch (Throwable throwable) {
                        U.close(in, (IgniteLogger)log);
                        throw throwable;
                    }
                    U.close((AutoCloseable)in, (IgniteLogger)log);
                }
                catch (IOException e) {
                    throw new IgniteSpiException("IO error when parsing GAR directory: " + gar.getAbsolutePath(), (Throwable)e);
                }
            }
        }
        if (res != null) {
            res.setMd5(GridUriDeploymentFileProcessor.md5(gar, log));
        }
        return res;
    }

    @Nullable
    public static String md5(@Nullable File file, @Nullable IgniteLogger log) {
        if (file != null) {
            return file.isFile() ? GridUriDeploymentFileProcessor.fileMd5(file, log) : GridUriDeploymentFileProcessor.directoryMd5(file, log);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static String fileMd5(@Nullable File file, @Nullable IgniteLogger log) {
        String md5 = null;
        if (file != null) {
            if (!file.isFile()) {
                U.warn((IgniteLogger)log, (Object)("Failed to find file for md5 calculation: " + file));
                return null;
            }
            BufferedInputStream in = null;
            try {
                in = new BufferedInputStream(new FileInputStream(file));
                md5 = DigestUtils.md5Hex((InputStream)in);
            }
            catch (IOException e) {
                try {
                    U.warn((IgniteLogger)log, (Object)("Failed to open input stream for md5 calculation: " + e.getMessage()));
                }
                catch (Throwable throwable) {
                    U.closeQuiet(in);
                    throw throwable;
                }
                U.closeQuiet((AutoCloseable)in);
            }
            U.closeQuiet((AutoCloseable)in);
        }
        return md5;
    }

    @Nullable
    public static String directoryMd5(@Nullable File dir, @Nullable IgniteLogger log) {
        if (dir != null) {
            if (!dir.isDirectory()) {
                U.warn((IgniteLogger)log, (Object)("Failed to find directory for md5 calculation: " + dir));
                return null;
            }
            try {
                MessageDigest digest = MessageDigest.getInstance("MD5");
                return GridUriDeploymentFileProcessor.addDirectoryDigest(dir, digest, log) ? Hex.encodeHexString((byte[])digest.digest()) : null;
            }
            catch (NoSuchAlgorithmException e) {
                throw new IgniteException("MD5 digest algorithm not found.", (Throwable)e);
            }
        }
        return null;
    }

    private static boolean addDirectoryDigest(File file, MessageDigest digest, @Nullable IgniteLogger log) {
        assert (file.isDirectory());
        Object[] files = file.listFiles();
        if (files == null) {
            return true;
        }
        Arrays.sort(files);
        for (Object visited : files) {
            if (!(((File)visited).isFile() ? !GridUriDeploymentFileProcessor.addFileDigest((File)visited, digest, log) : ((File)visited).isDirectory() && !GridUriDeploymentFileProcessor.addDirectoryDigest((File)visited, digest, log))) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean addFileDigest(File file, MessageDigest digest, @Nullable IgniteLogger log) {
        if (!file.isFile()) {
            U.error((IgniteLogger)log, (Object)("Failed to add file to directory digest (will not check MD5 hash): " + file));
            return false;
        }
        BufferedInputStream in = null;
        try {
            in = new BufferedInputStream(new FileInputStream(file));
            byte[] buf = new byte[1024];
            int read = ((InputStream)in).read(buf, 0, 1024);
            while (read > -1) {
                digest.update(buf, 0, read);
                read = ((InputStream)in).read(buf, 0, 1024);
            }
        }
        catch (IOException e) {
            boolean bl;
            try {
                U.error((IgniteLogger)log, (Object)("Failed to add file to directory digest (will not check MD5 hash): " + file), (Throwable)e);
                bl = false;
            }
            catch (Throwable throwable) {
                U.closeQuiet(in);
                throw throwable;
            }
            U.closeQuiet((AutoCloseable)in);
            return bl;
        }
        U.closeQuiet((AutoCloseable)in);
        return true;
    }

    static void cleanupUnit(ClassLoader clsLdr, IgniteLogger log) {
        assert (clsLdr != null);
        assert (log != null);
        assert (clsLdr instanceof URLClassLoader);
        URLClassLoader clsLdr0 = (URLClassLoader)clsLdr;
        U.close((URLClassLoader)clsLdr0, (IgniteLogger)log);
        try {
            URL url = IgniteUtils.classLoaderUrls((ClassLoader)clsLdr)[0];
            File dir = new File(url.toURI());
            U.delete((File)dir);
            if (dir.getName().startsWith("dirzip_")) {
                File jarFile = new File(dir.getParentFile(), dir.getName().substring(7));
                U.delete((File)jarFile);
            }
        }
        catch (Exception e) {
            U.error((IgniteLogger)log, (Object)("Failed to cleanup unit [clsLdr=" + clsLdr + ']'), (Throwable)e);
        }
    }

    private static GridUriDeploymentFileProcessorResult processWithDescriptorFile(GridUriDeploymentSpringDocument doc, File file, String uri, IgniteLogger log) throws IgniteSpiException {
        ClassLoader clsLdr = GridUriDeploymentClassLoaderFactory.create(U.gridClassLoader(), file, log);
        List<Class<ComputeTask<?, ?>>> tasks = doc.getTasks(clsLdr);
        ArrayList validTasks = null;
        if (!F.isEmpty(tasks)) {
            validTasks = new ArrayList();
            for (Class<ComputeTask<?, ?>> task : tasks) {
                if (!GridUriDeploymentFileProcessor.isAllowedTaskClass(task)) {
                    U.warn((IgniteLogger)log, (Object)("Failed to load task. Task should be public none-abstract class (might be inner static one) that implements ComputeTask interface [taskCls=" + task + ']'));
                    continue;
                }
                if (log.isDebugEnabled()) {
                    log.debug("Found grid deployment task: " + task.getName());
                }
                validTasks.add(task);
            }
        }
        GridUriDeploymentFileProcessorResult res = new GridUriDeploymentFileProcessorResult();
        res.setFile(file);
        res.setClassLoader(clsLdr);
        if (!F.isEmpty(validTasks)) {
            res.setTaskClasses(validTasks);
        } else if (log.isDebugEnabled()) {
            log.debug("No tasks loaded from file [file=" + file.getAbsolutePath() + ", uri=" + U.hidePassword((String)uri) + ']');
        }
        return res;
    }

    private static GridUriDeploymentFileProcessorResult processNoDescriptorFile(File file, String uri, IgniteLogger log) throws IgniteSpiException {
        ClassLoader clsLdr = GridUriDeploymentClassLoaderFactory.create(U.gridClassLoader(), file, log);
        Set<Class<ComputeTask<?, ?>>> clss = GridUriDeploymentDiscovery.getClasses(clsLdr, file);
        GridUriDeploymentFileProcessorResult res = new GridUriDeploymentFileProcessorResult();
        res.setFile(file);
        res.setClassLoader(clsLdr);
        if (clss != null) {
            ArrayList validTasks = new ArrayList(clss.size());
            for (Class<ComputeTask<?, ?>> cls : clss) {
                if (!GridUriDeploymentFileProcessor.isAllowedTaskClass(cls)) continue;
                if (log.isDebugEnabled()) {
                    log.debug("Found grid deployment task: " + cls.getName());
                }
                validTasks.add(cls);
            }
            if (!validTasks.isEmpty()) {
                res.setTaskClasses(validTasks);
            } else if (log.isDebugEnabled()) {
                log.debug("No tasks loaded from file [file=" + file.getAbsolutePath() + ", uri=" + U.hidePassword((String)uri) + ']');
            }
        }
        return res;
    }

    private static boolean isAllowedTaskClass(Class<?> cls) {
        if (!ComputeTask.class.isAssignableFrom(cls)) {
            return false;
        }
        int modifiers = cls.getModifiers();
        return !Modifier.isAbstract(modifiers) && !Modifier.isInterface(modifiers) && (!cls.isMemberClass() || Modifier.isStatic(modifiers)) && Modifier.isPublic(modifiers);
    }

    private static boolean checkIntegrity(File file, IgniteLogger log) {
        try {
            return file.isDirectory() || GridUriDeploymentJarVerifier.verify(file.getAbsolutePath(), false, log);
        }
        catch (IOException e) {
            U.error((IgniteLogger)log, (Object)"Error while making integrity file check.", (Throwable)e);
            return false;
        }
    }
}

