/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.rng.core;

import org.apache.commons.rng.RandomProviderState;
import org.apache.commons.rng.RestorableUniformRandomProvider;
import org.apache.commons.rng.core.RandomProviderDefaultState;

public abstract class BaseProvider
implements RestorableUniformRandomProvider {
    public int nextInt(int n) {
        int val;
        int bits;
        this.checkStrictlyPositive(n);
        if ((n & -n) == n) {
            return (int)((long)n * (long)(this.nextInt() >>> 1) >> 31);
        }
        while ((bits = this.nextInt() >>> 1) - (val = bits % n) + (n - 1) < 0) {
        }
        return val;
    }

    public long nextLong(long n) {
        long val;
        long bits;
        this.checkStrictlyPositive(n);
        while ((bits = this.nextLong() >>> 1) - (val = bits % n) + (n - 1L) < 0L) {
        }
        return val;
    }

    public RandomProviderState saveState() {
        return new RandomProviderDefaultState(this.getStateInternal());
    }

    public void restoreState(RandomProviderState state) {
        if (!(state instanceof RandomProviderDefaultState)) {
            throw new IllegalArgumentException("Foreign instance");
        }
        this.setStateInternal(((RandomProviderDefaultState)state).getState());
    }

    public String toString() {
        return this.getClass().getName();
    }

    protected byte[] getStateInternal() {
        throw new UnsupportedOperationException();
    }

    protected void setStateInternal(byte[] state) {
        throw new UnsupportedOperationException();
    }

    protected void fillState(int[] state, int[] seed) {
        int stateSize = state.length;
        int seedSize = seed.length;
        System.arraycopy(seed, 0, state, 0, Math.min(seedSize, stateSize));
        if (seedSize < stateSize) {
            for (int i = seedSize; i < stateSize; ++i) {
                state[i] = (int)(BaseProvider.scrambleWell(state[i - seed.length], i) & 0xFFFFFFFFL);
            }
        }
    }

    protected void fillState(long[] state, long[] seed) {
        int stateSize = state.length;
        int seedSize = seed.length;
        System.arraycopy(seed, 0, state, 0, Math.min(seedSize, stateSize));
        if (seedSize < stateSize) {
            for (int i = seedSize; i < stateSize; ++i) {
                state[i] = BaseProvider.scrambleWell(state[i - seed.length], i);
            }
        }
    }

    protected void checkStateSize(byte[] state, int expected) {
        if (state.length != expected) {
            throw new IllegalArgumentException("State size must be " + expected + " but was " + state.length);
        }
    }

    protected void checkIndex(int min, int max, int index) {
        if (index < min || index > max) {
            throw new IndexOutOfBoundsException(index + " is out of interval [" + min + ", " + max + "]");
        }
    }

    private void checkStrictlyPositive(long n) {
        if (n <= 0L) {
            throw new IllegalArgumentException("Must be strictly positive: " + n);
        }
    }

    private static long scramble(long n, long mult, int shift, int add) {
        return mult * (n ^ n >> shift) + (long)add;
    }

    private static long scrambleWell(long n, int add) {
        return BaseProvider.scramble(n, 1812433253L, 30, add);
    }
}

