/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.tensorflow.cluster.util;

import java.util.Map;
import org.apache.ignite.Ignite;
import org.apache.ignite.Ignition;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.tensorflow.core.util.PythonProcessBuilderSupplier;

public class TensorFlowProcessBuilderSupplier
extends PythonProcessBuilderSupplier {
    private static final long serialVersionUID = 6866243505446122897L;
    private static final String ENV_PREFIX = "IGNITE_DATASET_";
    private final Integer part;

    public TensorFlowProcessBuilderSupplier(boolean interactive, Integer part, String ... meta) {
        super(interactive, meta);
        this.part = part;
    }

    @Override
    public ProcessBuilder get() {
        ProcessBuilder pythonProcBuilder = super.get();
        Ignite ignite = Ignition.ignite();
        ClusterNode locNode = ignite.cluster().localNode();
        Integer port = (Integer)locNode.attribute("clientListenerPort");
        Map<String, String> env = pythonProcBuilder.environment();
        env.put("IGNITE_DATASET_HOST", "localhost");
        if (port != null) {
            env.put("IGNITE_DATASET_PORT", String.valueOf(port));
        }
        if (this.part != null) {
            env.put("IGNITE_DATASET_PART", String.valueOf(this.part));
        }
        return pythonProcBuilder;
    }
}

