/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.tensorflow.cluster.util;

import java.util.concurrent.ExecutorService;
import java.util.function.Consumer;
import org.apache.ignite.Ignite;
import org.apache.ignite.tensorflow.cluster.spec.TensorFlowClusterSpec;
import org.apache.ignite.tensorflow.cluster.tfrunning.TensorFlowServer;
import org.apache.ignite.tensorflow.cluster.tfrunning.TensorFlowServerScriptFormatter;
import org.apache.ignite.tensorflow.core.util.AsyncNativeProcessRunner;
import org.apache.ignite.tensorflow.core.util.NativeProcessRunner;
import org.apache.ignite.tensorflow.core.util.PythonProcessBuilderSupplier;

public class TensorFlowChiefRunner
extends AsyncNativeProcessRunner {
    private final Ignite ignite;
    private final TensorFlowClusterSpec spec;
    private final Consumer<String> out;
    private final Consumer<String> err;

    public TensorFlowChiefRunner(Ignite ignite, ExecutorService executor, TensorFlowClusterSpec spec, Consumer<String> out, Consumer<String> err) {
        super(ignite, executor);
        this.ignite = ignite;
        this.spec = spec;
        this.out = out;
        this.err = err;
    }

    @Override
    public NativeProcessRunner doBefore() {
        TensorFlowServer srv = new TensorFlowServer(this.spec, "chief", 0);
        return new NativeProcessRunner(new PythonProcessBuilderSupplier(true, "job:" + srv.getJobName(), "task:" + srv.getTaskIdx()).get(), new TensorFlowServerScriptFormatter().format(srv, true, this.ignite), this.out, this.err);
    }

    @Override
    public void doAfter() {
    }
}

