/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.tensorflow.cluster.spec;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.ignite.Ignite;
import org.apache.ignite.tensorflow.cluster.spec.TensorFlowServerAddressSpec;

public class TensorFlowClusterSpec
implements Serializable {
    private static final long serialVersionUID = 1428581667528448091L;
    private final Map<String, List<TensorFlowServerAddressSpec>> jobs = new HashMap<String, List<TensorFlowServerAddressSpec>>();

    public TensorFlowClusterSpec addTask(String jobName, UUID nodeId, int port) {
        this.jobs.putIfAbsent(jobName, new ArrayList());
        List<TensorFlowServerAddressSpec> tasks = this.jobs.get(jobName);
        tasks.add(new TensorFlowServerAddressSpec(nodeId, port));
        return this;
    }

    public String format(Ignite ignite) {
        StringBuilder builder = new StringBuilder();
        builder.append("{\n");
        for (Map.Entry<String, List<TensorFlowServerAddressSpec>> entry : this.jobs.entrySet()) {
            builder.append("\t\"").append(entry.getKey()).append("\" : [ ");
            for (TensorFlowServerAddressSpec address : entry.getValue()) {
                builder.append("\n\t\t\"").append(address.format(ignite)).append("\", ");
            }
            if (!entry.getValue().isEmpty()) {
                builder.delete(builder.length() - 2, builder.length());
            }
            builder.append("\n\t],\n");
        }
        if (!this.jobs.isEmpty()) {
            builder.delete(builder.length() - 2, builder.length() - 1);
        }
        builder.append('}');
        return builder.toString();
    }

    public Map<String, List<TensorFlowServerAddressSpec>> getJobs() {
        return this.jobs;
    }
}

