/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.network.shuffle;

import com.codahale.metrics.MetricSet;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.apache.spark.network.TransportContext;
import org.apache.spark.network.client.TransportClient;
import org.apache.spark.network.client.TransportClientFactory;
import org.apache.spark.network.crypto.AuthClientBootstrap;
import org.apache.spark.network.sasl.SecretKeyHolder;
import org.apache.spark.network.server.NoOpRpcHandler;
import org.apache.spark.network.server.RpcHandler;
import org.apache.spark.network.shuffle.BlockFetchingListener;
import org.apache.spark.network.shuffle.OneForOneBlockFetcher;
import org.apache.spark.network.shuffle.RetryingBlockFetcher;
import org.apache.spark.network.shuffle.ShuffleClient;
import org.apache.spark.network.shuffle.TempFileManager;
import org.apache.spark.network.shuffle.protocol.ExecutorShuffleInfo;
import org.apache.spark.network.shuffle.protocol.RegisterExecutor;
import org.apache.spark.network.util.TransportConf;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spark_project.guava.collect.Lists;

public class ExternalShuffleClient
extends ShuffleClient {
    private static final Logger logger = LoggerFactory.getLogger(ExternalShuffleClient.class);
    private final TransportConf conf;
    private final boolean authEnabled;
    private final SecretKeyHolder secretKeyHolder;
    private final long registrationTimeoutMs;
    protected TransportClientFactory clientFactory;
    protected String appId;

    public ExternalShuffleClient(TransportConf conf, SecretKeyHolder secretKeyHolder, boolean authEnabled, long registrationTimeoutMs) {
        this.conf = conf;
        this.secretKeyHolder = secretKeyHolder;
        this.authEnabled = authEnabled;
        this.registrationTimeoutMs = registrationTimeoutMs;
    }

    protected void checkInit() {
        assert (this.appId != null) : "Called before init()";
    }

    @Override
    public void init(String appId) {
        this.appId = appId;
        TransportContext context = new TransportContext(this.conf, (RpcHandler)new NoOpRpcHandler(), true);
        ArrayList bootstraps = Lists.newArrayList();
        if (this.authEnabled) {
            bootstraps.add(new AuthClientBootstrap(this.conf, appId, this.secretKeyHolder));
        }
        this.clientFactory = context.createClientFactory((List)bootstraps);
    }

    @Override
    public void fetchBlocks(String host, int port, String execId, String[] blockIds, BlockFetchingListener listener, TempFileManager tempFileManager) {
        this.checkInit();
        logger.debug("External shuffle fetch from {}:{} (executor id {})", new Object[]{host, port, execId});
        try {
            RetryingBlockFetcher.BlockFetchStarter blockFetchStarter = (blockIds1, listener1) -> {
                TransportClient client = this.clientFactory.createClient(host, port);
                new OneForOneBlockFetcher(client, this.appId, execId, blockIds1, listener1, this.conf, tempFileManager).start();
            };
            int maxRetries = this.conf.maxIORetries();
            if (maxRetries > 0) {
                new RetryingBlockFetcher(this.conf, blockFetchStarter, blockIds, listener).start();
            } else {
                blockFetchStarter.createAndStart(blockIds, listener);
            }
        }
        catch (Exception e) {
            logger.error("Exception while beginning fetchBlocks", (Throwable)e);
            for (String blockId : blockIds) {
                listener.onBlockFetchFailure(blockId, e);
            }
        }
    }

    @Override
    public MetricSet shuffleMetrics() {
        this.checkInit();
        return this.clientFactory.getAllMetrics();
    }

    public void registerWithShuffleServer(String host, int port, String execId, ExecutorShuffleInfo executorInfo) throws IOException, InterruptedException {
        this.checkInit();
        try (TransportClient client = this.clientFactory.createUnmanagedClient(host, port);){
            ByteBuffer registerMessage = new RegisterExecutor(this.appId, execId, executorInfo).toByteBuffer();
            client.sendRpcSync(registerMessage, this.registrationTimeoutMs);
        }
    }

    @Override
    public void close() {
        this.checkInit();
        if (this.clientFactory != null) {
            this.clientFactory.close();
            this.clientFactory = null;
        }
    }
}

