/*
 * Decompiled with CFR 0.152.
 */
package zmq;

import java.io.IOException;
import java.nio.channels.SelectableChannel;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import zmq.Address;
import zmq.Clock;
import zmq.Command;
import zmq.Config;
import zmq.Ctx;
import zmq.Dealer;
import zmq.IOThread;
import zmq.IPollEvents;
import zmq.IpcListener;
import zmq.Mailbox;
import zmq.Msg;
import zmq.MultiMap;
import zmq.Own;
import zmq.Pair;
import zmq.Pipe;
import zmq.Poller;
import zmq.Pub;
import zmq.Pull;
import zmq.Push;
import zmq.Rep;
import zmq.Req;
import zmq.Router;
import zmq.SessionBase;
import zmq.Sub;
import zmq.TcpListener;
import zmq.ValueReference;
import zmq.XPub;
import zmq.XSub;
import zmq.ZError;
import zmq.ZMQ;
import zmq.ZObject;

public abstract class SocketBase
extends Own
implements IPollEvents,
Pipe.IPipeEvents {
    private final Map<String, Own> endpoints;
    private final Map<String, Pipe> inprocs;
    private int tag = -1159861073;
    private boolean ctxTerminated = false;
    private boolean destroyed = false;
    private final Mailbox mailbox;
    private final List<Pipe> pipes;
    private Poller poller;
    private SelectableChannel handle;
    private long lastTsc = 0L;
    private int ticks = 0;
    private boolean rcvmore = false;
    private SocketBase monitorSocket = null;
    private int monitorEvents = 0;
    protected ValueReference<Integer> errno;

    protected SocketBase(Ctx parent, int tid, int sid) {
        super(parent, tid);
        this.options.socketId = sid;
        this.options.linger = parent.get(70) != 0 ? -1 : 0;
        this.endpoints = new MultiMap<String, Own>();
        this.inprocs = new MultiMap<String, Pipe>();
        this.pipes = new ArrayList<Pipe>();
        this.mailbox = new Mailbox("socket-" + sid);
        this.errno = new ValueReference<Integer>(0);
    }

    protected abstract void xattachPipe(Pipe var1, boolean var2);

    protected abstract void xpipeTerminated(Pipe var1);

    public boolean checkTag() {
        return this.tag == -1159861073;
    }

    public static SocketBase create(int type, Ctx parent, int tid, int sid) {
        SocketBase s = null;
        switch (type) {
            case 0: {
                s = new Pair(parent, tid, sid);
                break;
            }
            case 1: {
                s = new Pub(parent, tid, sid);
                break;
            }
            case 2: {
                s = new Sub(parent, tid, sid);
                break;
            }
            case 3: {
                s = new Req(parent, tid, sid);
                break;
            }
            case 4: {
                s = new Rep(parent, tid, sid);
                break;
            }
            case 5: {
                s = new Dealer(parent, tid, sid);
                break;
            }
            case 6: {
                s = new Router(parent, tid, sid);
                break;
            }
            case 7: {
                s = new Pull(parent, tid, sid);
                break;
            }
            case 8: {
                s = new Push(parent, tid, sid);
                break;
            }
            case 9: {
                s = new XPub(parent, tid, sid);
                break;
            }
            case 10: {
                s = new XSub(parent, tid, sid);
                break;
            }
            default: {
                throw new IllegalArgumentException("type=" + type);
            }
        }
        return s;
    }

    @Override
    public void destroy() {
        try {
            this.mailbox.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.stopMonitor();
        assert (this.destroyed);
    }

    public Mailbox getMailbox() {
        return this.mailbox;
    }

    public void stop() {
        this.sendStop();
    }

    private void checkProtocol(String protocol) {
        if (!(protocol.equals("inproc") || protocol.equals("ipc") || protocol.equals("tcp"))) {
            throw new UnsupportedOperationException(protocol);
        }
        if ((protocol.equals("pgm") || protocol.equals("epgm")) && this.options.type != 1 && this.options.type != 2 && this.options.type != 9 && this.options.type != 10) {
            throw new UnsupportedOperationException(protocol + ",type=" + this.options.type);
        }
    }

    private void attachPipe(Pipe pipe) {
        this.attachPipe(pipe, false);
    }

    private void attachPipe(Pipe pipe, boolean icanhasall) {
        pipe.setEventSink(this);
        this.pipes.add(pipe);
        this.xattachPipe(pipe, icanhasall);
        if (this.isTerminating()) {
            this.registerTermAcks(1);
            pipe.terminate(false);
        }
    }

    public void setSocketOpt(int option, Object optval) {
        if (this.ctxTerminated) {
            throw new ZError.CtxTerminatedException();
        }
        if (this.xsetsockopt(option, optval)) {
            return;
        }
        this.options.setSocketOpt(option, optval);
    }

    public int getSocketOpt(int option) {
        if (option != 15 && this.ctxTerminated) {
            throw new ZError.CtxTerminatedException();
        }
        if (option == 13) {
            return this.rcvmore ? 1 : 0;
        }
        if (option == 15) {
            boolean rc = this.processCommands(0, false);
            if (!rc && this.errno.get() == 156384765) {
                return -1;
            }
            assert (rc);
            int val = 0;
            if (this.hasOut()) {
                val |= 2;
            }
            if (this.hasIn()) {
                val |= 1;
            }
            return val;
        }
        return (Integer)this.getsockoptx(option);
    }

    public Object getsockoptx(int option) {
        if (this.ctxTerminated) {
            throw new ZError.CtxTerminatedException();
        }
        if (option == 13) {
            return this.rcvmore ? 1 : 0;
        }
        if (option == 14) {
            return this.mailbox.getFd();
        }
        if (option == 15) {
            boolean rc = this.processCommands(0, false);
            if (!rc && this.errno.get() == 156384765) {
                return -1;
            }
            assert (rc);
            int val = 0;
            if (this.hasOut()) {
                val |= 2;
            }
            if (this.hasIn()) {
                val |= 1;
            }
            return val;
        }
        return this.options.getsockopt(option);
    }

    public boolean bind(String addr) {
        if (this.ctxTerminated) {
            throw new ZError.CtxTerminatedException();
        }
        boolean brc = this.processCommands(0, false);
        if (!brc) {
            return false;
        }
        SimpleURI uri = SimpleURI.create(addr);
        String protocol = uri.getProtocol();
        String address = uri.getAddress();
        this.checkProtocol(protocol);
        if (protocol.equals("inproc")) {
            Ctx.Endpoint endpoint = new Ctx.Endpoint(this, this.options);
            boolean rc = this.registerEndpoint(addr, endpoint);
            if (rc) {
                this.options.lastEndpoint = addr;
            } else {
                this.errno.set(48);
            }
            return rc;
        }
        if (protocol.equals("pgm") || protocol.equals("epgm")) {
            return this.connect(addr);
        }
        IOThread ioThread = this.chooseIoThread(this.options.affinity);
        if (ioThread == null) {
            throw new IllegalStateException("EMTHREAD");
        }
        if (protocol.equals("tcp")) {
            TcpListener listener = new TcpListener(ioThread, this, this.options);
            int rc = listener.setAddress(address);
            if (rc != 0) {
                listener.destroy();
                this.eventBindFailed(address, rc);
                this.errno.set(rc);
                return false;
            }
            this.options.lastEndpoint = listener.getAddress();
            this.addEndpoint(addr, listener);
            return true;
        }
        if (protocol.equals("ipc")) {
            IpcListener listener = new IpcListener(ioThread, this, this.options);
            int rc = listener.setAddress(address);
            if (rc != 0) {
                listener.destroy();
                this.eventBindFailed(address, rc);
                this.errno.set(rc);
                return false;
            }
            this.options.lastEndpoint = listener.getAddress();
            this.addEndpoint(addr, listener);
            return true;
        }
        throw new IllegalArgumentException(addr);
    }

    public boolean connect(String addr) {
        if (this.ctxTerminated) {
            throw new ZError.CtxTerminatedException();
        }
        boolean brc = this.processCommands(0, false);
        if (!brc) {
            return false;
        }
        SimpleURI uri = SimpleURI.create(addr);
        String protocol = uri.getProtocol();
        String address = uri.getAddress();
        this.checkProtocol(protocol);
        if (protocol.equals("inproc")) {
            boolean written;
            Msg id;
            Ctx.Endpoint peer = this.findEndpoint(addr);
            if (peer.socket == null) {
                return false;
            }
            int sndhwm = 0;
            if (this.options.sendHwm != 0 && peer.options.recvHwm != 0) {
                sndhwm = this.options.sendHwm + peer.options.recvHwm;
            }
            int rcvhwm = 0;
            if (this.options.recvHwm != 0 && peer.options.sendHwm != 0) {
                rcvhwm = this.options.recvHwm + peer.options.sendHwm;
            }
            ZObject[] parents = new ZObject[]{this, peer.socket};
            Pipe[] pipes = new Pipe[]{null, null};
            int[] hwms = new int[]{sndhwm, rcvhwm};
            boolean[] delays = new boolean[]{this.options.delayOnDisconnect, this.options.delayOnClose};
            Pipe.pipepair(parents, pipes, hwms, delays);
            this.attachPipe(pipes[0]);
            if (peer.options.recvIdentity) {
                id = new Msg(this.options.identitySize);
                id.put(this.options.identity, 0, this.options.identitySize);
                id.setFlags(64);
                written = pipes[0].write(id);
                assert (written);
                pipes[0].flush();
            }
            if (this.options.recvIdentity) {
                id = new Msg(peer.options.identitySize);
                id.put(peer.options.identity, 0, peer.options.identitySize);
                id.setFlags(64);
                written = pipes[1].write(id);
                assert (written);
                pipes[1].flush();
            }
            this.sendBind(peer.socket, pipes[1], false);
            this.options.lastEndpoint = addr;
            this.inprocs.put(addr, pipes[0]);
            return true;
        }
        IOThread ioThread = this.chooseIoThread(this.options.affinity);
        if (ioThread == null) {
            throw new IllegalStateException("Empty IO Thread");
        }
        boolean ipv4only = this.options.ipv4only != 0;
        Address paddr = new Address(protocol, address, ipv4only);
        paddr.resolve();
        SessionBase session = SessionBase.create(ioThread, true, this, this.options, paddr);
        assert (session != null);
        boolean icanhasall = false;
        if (protocol.equals("pgm") || protocol.equals("epgm")) {
            icanhasall = true;
        }
        if (this.options.delayAttachOnConnect != 1 || icanhasall) {
            ZObject[] parents = new ZObject[]{this, session};
            Pipe[] pipes = new Pipe[]{null, null};
            int[] hwms = new int[]{this.options.sendHwm, this.options.recvHwm};
            boolean[] delays = new boolean[]{this.options.delayOnDisconnect, this.options.delayOnClose};
            Pipe.pipepair(parents, pipes, hwms, delays);
            this.attachPipe(pipes[0], icanhasall);
            session.attachPipe(pipes[1]);
        }
        this.options.lastEndpoint = paddr.toString();
        this.addEndpoint(addr, session);
        return true;
    }

    private void addEndpoint(String addr, Own endpoint) {
        this.launchChild(endpoint);
        this.endpoints.put(addr, endpoint);
    }

    public boolean termEndpoint(String addr) {
        if (this.ctxTerminated) {
            throw new ZError.CtxTerminatedException();
        }
        if (addr == null) {
            throw new IllegalArgumentException();
        }
        boolean rc = this.processCommands(0, false);
        if (!rc) {
            return false;
        }
        SimpleURI uri = SimpleURI.create(addr);
        String protocol = uri.getProtocol();
        if (protocol.equals("inproc")) {
            if (!this.inprocs.containsKey(addr)) {
                return false;
            }
            Iterator<Map.Entry<String, Pipe>> it = this.inprocs.entrySet().iterator();
            while (it.hasNext()) {
                it.next().getValue().terminate(true);
                it.remove();
            }
            return true;
        }
        if (!this.endpoints.containsKey(addr)) {
            return false;
        }
        Iterator<Map.Entry<String, Own>> it = this.endpoints.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, Own> e = it.next();
            if (!e.getKey().equals(addr)) continue;
            this.termChild(e.getValue());
            it.remove();
        }
        return true;
    }

    public boolean send(Msg msg, int flags) {
        block9: {
            long end;
            boolean rc;
            if (this.ctxTerminated) {
                this.errno.set(156384765);
                return false;
            }
            if (msg == null) {
                throw new IllegalArgumentException();
            }
            boolean brc = this.processCommands(0, true);
            if (!brc) {
                return false;
            }
            msg.resetFlags(1);
            if ((flags & 2) > 0) {
                msg.setFlags(1);
            }
            if (rc = this.xsend(msg)) {
                return true;
            }
            if (this.errno.get() != 35) {
                return false;
            }
            if ((flags & 1) > 0 || this.options.sendTimeout == 0) {
                return false;
            }
            int timeout = this.options.sendTimeout;
            long l = end = timeout < 0 ? 0L : Clock.nowMS() + (long)timeout;
            do {
                if (!this.processCommands(timeout, false)) {
                    return false;
                }
                rc = this.xsend(msg);
                if (rc) break block9;
                if (this.errno.get() == 35) continue;
                return false;
            } while (timeout <= 0 || (timeout = (int)(end - Clock.nowMS())) > 0);
            this.errno.set(35);
            return false;
        }
        return true;
    }

    public Msg recv(int flags) {
        Msg msg;
        block11: {
            if (this.ctxTerminated) {
                this.errno.set(156384765);
                return null;
            }
            if (++this.ticks == Config.INBOUND_POLL_RATE.getValue()) {
                if (!this.processCommands(0, false)) {
                    return null;
                }
                this.ticks = 0;
            }
            if ((msg = this.xrecv()) == null && this.errno.get() != 35) {
                return null;
            }
            if (msg != null) {
                this.extractFlags(msg);
                return msg;
            }
            if ((flags & 1) > 0 || this.options.recvTimeout == 0) {
                if (!this.processCommands(0, false)) {
                    return null;
                }
                this.ticks = 0;
                msg = this.xrecv();
                if (msg == null) {
                    return null;
                }
                this.extractFlags(msg);
                return msg;
            }
            int timeout = this.options.recvTimeout;
            long end = timeout < 0 ? 0L : Clock.nowMS() + (long)timeout;
            boolean block = this.ticks != 0;
            do {
                if (!this.processCommands(block ? timeout : 0, false)) {
                    return null;
                }
                msg = this.xrecv();
                if (msg != null) break block11;
                if (this.errno.get() != 35) {
                    return null;
                }
                block = true;
            } while (timeout <= 0 || (timeout = (int)(end - Clock.nowMS())) > 0);
            this.errno.set(35);
            return null;
        }
        this.ticks = 0;
        this.extractFlags(msg);
        return msg;
    }

    public void close() {
        this.tag = -559038737;
        this.sendReap(this);
    }

    boolean hasIn() {
        return this.xhasIn();
    }

    boolean hasOut() {
        return this.xhasOut();
    }

    public void startReaping(Poller poller) {
        this.poller = poller;
        this.handle = this.mailbox.getFd();
        this.poller.addHandle(this.handle, this);
        this.poller.setPollIn(this.handle);
        this.terminate();
        this.checkDestroy();
    }

    private boolean processCommands(int timeout, boolean throttle) {
        Command cmd;
        if (timeout != 0) {
            cmd = this.mailbox.recv(timeout);
        } else {
            long tsc = 0L;
            if (tsc != 0L && throttle) {
                if (tsc >= this.lastTsc && tsc - this.lastTsc <= (long)Config.MAX_COMMAND_DELAY.getValue()) {
                    return true;
                }
                this.lastTsc = tsc;
            }
            cmd = this.mailbox.recv(0L);
        }
        while (cmd != null) {
            cmd.destination().processCommand(cmd);
            cmd = this.mailbox.recv(0L);
        }
        if (this.ctxTerminated) {
            this.errno.set(156384765);
            return false;
        }
        return true;
    }

    @Override
    protected void processStop() {
        this.stopMonitor();
        this.ctxTerminated = true;
    }

    @Override
    protected void processBind(Pipe pipe) {
        this.attachPipe(pipe);
    }

    @Override
    protected void processTerm(int linger) {
        this.unregisterEndpoints(this);
        for (int i = 0; i != this.pipes.size(); ++i) {
            this.pipes.get(i).terminate(false);
        }
        this.registerTermAcks(this.pipes.size());
        super.processTerm(linger);
    }

    @Override
    protected void processDestroy() {
        this.destroyed = true;
    }

    protected boolean xsetsockopt(int option, Object optval) {
        return false;
    }

    protected boolean xhasOut() {
        return false;
    }

    protected boolean xsend(Msg msg) {
        throw new UnsupportedOperationException("Must Override");
    }

    protected boolean xhasIn() {
        return false;
    }

    protected Msg xrecv() {
        throw new UnsupportedOperationException("Must Override");
    }

    protected void xreadActivated(Pipe pipe) {
        throw new UnsupportedOperationException("Must Override");
    }

    protected void xwriteActivated(Pipe pipe) {
        throw new UnsupportedOperationException("Must Override");
    }

    protected void xhiccuped(Pipe pipe) {
        throw new UnsupportedOperationException("Must override");
    }

    @Override
    public void inEvent() {
        try {
            this.processCommands(0, false);
        }
        catch (ZError.CtxTerminatedException ctxTerminatedException) {
            // empty catch block
        }
        this.checkDestroy();
    }

    @Override
    public void outEvent() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void connectEvent() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void acceptEvent() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void timerEvent(int id) {
        throw new UnsupportedOperationException();
    }

    private void checkDestroy() {
        if (this.destroyed) {
            this.poller.removeHandle(this.handle);
            this.destroySocket(this);
            this.sendReaped();
            super.processDestroy();
        }
    }

    @Override
    public void readActivated(Pipe pipe) {
        this.xreadActivated(pipe);
    }

    @Override
    public void writeActivated(Pipe pipe) {
        this.xwriteActivated(pipe);
    }

    @Override
    public void hiccuped(Pipe pipe) {
        if (this.options.delayAttachOnConnect == 1) {
            pipe.terminate(false);
        } else {
            this.xhiccuped(pipe);
        }
    }

    @Override
    public void pipeTerminated(Pipe pipe) {
        this.xpipeTerminated(pipe);
        Iterator<Map.Entry<String, Pipe>> it = this.inprocs.entrySet().iterator();
        while (it.hasNext()) {
            if (it.next().getValue() != pipe) continue;
            it.remove();
            break;
        }
        this.pipes.remove(pipe);
        if (this.isTerminating()) {
            this.unregisterTermAck();
        }
    }

    private void extractFlags(Msg msg) {
        if ((msg.flags() & 0x40) > 0) assert (this.options.recvIdentity);
        this.rcvmore = msg.hasMore();
    }

    public boolean monitor(String addr, int events) {
        if (this.ctxTerminated) {
            throw new ZError.CtxTerminatedException();
        }
        if (addr == null) {
            this.stopMonitor();
            return true;
        }
        SimpleURI uri = SimpleURI.create(addr);
        String protocol = uri.getProtocol();
        this.checkProtocol(protocol);
        if (!protocol.equals("inproc")) {
            this.stopMonitor();
            throw new IllegalArgumentException("inproc socket required");
        }
        this.monitorEvents = events;
        this.monitorSocket = this.getCtx().createSocket(0);
        if (this.monitorSocket == null) {
            return false;
        }
        int linger = 0;
        try {
            this.monitorSocket.setSocketOpt(17, linger);
        }
        catch (IllegalArgumentException e) {
            this.stopMonitor();
            throw e;
        }
        boolean rc = this.monitorSocket.bind(addr);
        if (!rc) {
            this.stopMonitor();
        }
        return rc;
    }

    public void eventConnected(String addr, SelectableChannel ch) {
        if ((this.monitorEvents & 1) == 0) {
            return;
        }
        this.monitorEvent(new ZMQ.Event(1, addr, ch));
    }

    public void eventConnectDelayed(String addr, int errno) {
        if ((this.monitorEvents & 2) == 0) {
            return;
        }
        this.monitorEvent(new ZMQ.Event(2, addr, errno));
    }

    public void eventConnectRetried(String addr, int interval) {
        if ((this.monitorEvents & 4) == 0) {
            return;
        }
        this.monitorEvent(new ZMQ.Event(4, addr, interval));
    }

    public void eventListening(String addr, SelectableChannel ch) {
        if ((this.monitorEvents & 8) == 0) {
            return;
        }
        this.monitorEvent(new ZMQ.Event(8, addr, ch));
    }

    public void eventBindFailed(String addr, int errno) {
        if ((this.monitorEvents & 0x10) == 0) {
            return;
        }
        this.monitorEvent(new ZMQ.Event(16, addr, errno));
    }

    public void eventAccepted(String addr, SelectableChannel ch) {
        if ((this.monitorEvents & 0x20) == 0) {
            return;
        }
        this.monitorEvent(new ZMQ.Event(32, addr, ch));
    }

    public void eventAcceptFailed(String addr, int errno) {
        if ((this.monitorEvents & 0x40) == 0) {
            return;
        }
        this.monitorEvent(new ZMQ.Event(64, addr, errno));
    }

    public void eventClosed(String addr, SelectableChannel ch) {
        if ((this.monitorEvents & 0x80) == 0) {
            return;
        }
        this.monitorEvent(new ZMQ.Event(128, addr, ch));
    }

    public void eventCloseFailed(String addr, int errno) {
        if ((this.monitorEvents & 0x100) == 0) {
            return;
        }
        this.monitorEvent(new ZMQ.Event(256, addr, errno));
    }

    public void eventDisconnected(String addr, SelectableChannel ch) {
        if ((this.monitorEvents & 0x200) == 0) {
            return;
        }
        this.monitorEvent(new ZMQ.Event(512, addr, ch));
    }

    protected void monitorEvent(ZMQ.Event event) {
        if (this.monitorSocket == null) {
            return;
        }
        event.write(this.monitorSocket);
    }

    protected void stopMonitor() {
        if (this.monitorSocket != null) {
            if ((this.monitorEvents & 0x400) != 0) {
                this.monitorEvent(new ZMQ.Event(1024, "", 0));
            }
            this.monitorSocket.close();
            this.monitorSocket = null;
            this.monitorEvents = 0;
        }
    }

    public String toString() {
        return super.toString() + "[" + this.options.socketId + "]";
    }

    public SelectableChannel getFD() {
        return this.mailbox.getFd();
    }

    public String typeString() {
        switch (this.options.type) {
            case 0: {
                return "PAIR";
            }
            case 1: {
                return "PUB";
            }
            case 2: {
                return "SUB";
            }
            case 3: {
                return "REQ";
            }
            case 4: {
                return "REP";
            }
            case 5: {
                return "DEALER";
            }
            case 6: {
                return "ROUTER";
            }
            case 7: {
                return "PULL";
            }
            case 8: {
                return "PUSH";
            }
        }
        return "UNKOWN";
    }

    public int errno() {
        return this.errno.get();
    }

    private static class SimpleURI {
        private final String protocol;
        private final String address;

        private SimpleURI(String protocol, String address) {
            this.protocol = protocol;
            this.address = address;
        }

        public static SimpleURI create(String value) {
            int pos = value.indexOf("://");
            if (pos < 0) {
                throw new IllegalArgumentException("Invalid URI: " + value);
            }
            String protocol = value.substring(0, pos);
            String address = value.substring(pos + 3);
            if (protocol.isEmpty() || address.isEmpty()) {
                throw new IllegalArgumentException("Invalid URI: " + value);
            }
            return new SimpleURI(protocol, address);
        }

        public String getProtocol() {
            return this.protocol;
        }

        public String getAddress() {
            return this.address;
        }
    }
}

