/*
 * Decompiled with CFR 0.152.
 */
package zmq;

import java.io.IOException;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import zmq.IPollEvents;
import zmq.PollerBase;
import zmq.ZError;

public class Poller
extends PollerBase
implements Runnable {
    private final Map<SelectableChannel, PollSet> fdTable;
    private final AtomicBoolean retired = new AtomicBoolean(false);
    private volatile boolean stopping;
    private volatile boolean stopped;
    private Thread worker;
    private Selector selector;
    private final String name;

    public Poller() {
        this("poller");
    }

    public Poller(String name) {
        this.name = name;
        this.stopping = false;
        this.stopped = false;
        this.fdTable = new HashMap<SelectableChannel, PollSet>();
        try {
            this.selector = Selector.open();
        }
        catch (IOException e) {
            throw new ZError.IOException(e);
        }
    }

    public void destroy() {
        if (!this.stopped) {
            try {
                this.worker.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        try {
            this.selector.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public final void addHandle(SelectableChannel fd, IPollEvents events) {
        this.fdTable.put(fd, new PollSet(events));
        this.adjustLoad(1);
    }

    public final void removeHandle(SelectableChannel handle) {
        this.fdTable.get((Object)handle).cancelled = true;
        this.retired.set(true);
        this.adjustLoad(-1);
    }

    public final void setPollIn(SelectableChannel handle) {
        this.register(handle, 1, false);
    }

    public final void resetPollOn(SelectableChannel handle) {
        this.register(handle, 1, true);
    }

    public final void setPollOut(SelectableChannel handle) {
        this.register(handle, 4, false);
    }

    public final void resetPollOut(SelectableChannel handle) {
        this.register(handle, 4, true);
    }

    public final void setPollConnect(SelectableChannel handle) {
        this.register(handle, 8, false);
    }

    public final void setPollAccept(SelectableChannel handle) {
        this.register(handle, 16, false);
    }

    private final void register(SelectableChannel handle, int ops, boolean negate) {
        PollSet pollset = this.fdTable.get(handle);
        pollset.ops = negate ? (pollset.ops &= ~ops) : (pollset.ops |= ops);
        if (pollset.key != null) {
            pollset.key.interestOps(pollset.ops);
        } else {
            this.retired.set(true);
        }
    }

    public void start() {
        this.worker = new Thread((Runnable)this, this.name);
        this.worker.setDaemon(true);
        this.worker.start();
    }

    public void stop() {
        this.stopping = true;
        this.selector.wakeup();
    }

    @Override
    public void run() {
        int returnsImmediately = 0;
        while (!this.stopping) {
            int rc;
            long timeout = this.executeTimers();
            while (this.retired.compareAndSet(true, false)) {
                Iterator<Map.Entry<SelectableChannel, PollSet>> it = this.fdTable.entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry<SelectableChannel, PollSet> entry = it.next();
                    SelectableChannel ch = entry.getKey();
                    PollSet pollset = entry.getValue();
                    if (pollset.key == null) {
                        try {
                            pollset.key = ch.register(this.selector, pollset.ops, pollset.handler);
                        }
                        catch (ClosedChannelException closedChannelException) {
                            // empty catch block
                        }
                    }
                    if (!pollset.cancelled && ch.isOpen()) continue;
                    if (pollset.key != null) {
                        pollset.key.cancel();
                    }
                    it.remove();
                }
            }
            long start = System.currentTimeMillis();
            try {
                rc = this.selector.select(timeout);
            }
            catch (IOException e) {
                throw new ZError.IOException(e);
            }
            if (rc == 0) {
                returnsImmediately = timeout == 0L || System.currentTimeMillis() - start < timeout / 2L ? ++returnsImmediately : 0;
                if (returnsImmediately <= 10) continue;
                this.rebuildSelector();
                returnsImmediately = 0;
                continue;
            }
            Iterator<SelectionKey> it = this.selector.selectedKeys().iterator();
            while (it.hasNext()) {
                SelectionKey key = it.next();
                IPollEvents evt = (IPollEvents)key.attachment();
                it.remove();
                try {
                    if (key.isReadable()) {
                        evt.inEvent();
                    } else if (key.isAcceptable()) {
                        evt.acceptEvent();
                    } else if (key.isConnectable()) {
                        evt.connectEvent();
                    }
                    if (!key.isWritable()) continue;
                    evt.outEvent();
                }
                catch (CancelledKeyException cancelledKeyException) {}
            }
        }
        this.stopped = true;
    }

    private void rebuildSelector() {
        Selector newSelector;
        try {
            newSelector = Selector.open();
        }
        catch (IOException e) {
            throw new ZError.IOException(e);
        }
        try {
            this.selector.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.selector = newSelector;
        for (PollSet pollSet : this.fdTable.values()) {
            pollSet.key = null;
        }
        this.retired.set(true);
    }

    private static class PollSet {
        protected IPollEvents handler;
        protected SelectionKey key;
        protected int ops;
        protected boolean cancelled;

        protected PollSet(IPollEvents handler) {
            this.handler = handler;
            this.key = null;
            this.cancelled = false;
            this.ops = 0;
        }
    }
}

