/*
 * Decompiled with CFR 0.152.
 */
package zmq;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class MultiMap<K extends Comparable<? super K>, V>
implements Map<K, V> {
    private long id = 0L;
    private final HashMap<Long, V> values = new HashMap();
    private final TreeMap<K, ArrayList<Long>> keys = new TreeMap();

    @Override
    public void clear() {
        this.keys.clear();
        this.values.clear();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.keys.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.values.containsValue(value);
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return new MultiMapEntrySet(this);
    }

    @Override
    public V get(Object key) {
        ArrayList<Long> l = this.keys.get(key);
        if (l == null) {
            return null;
        }
        return this.values.get(l.get(0));
    }

    @Override
    public boolean isEmpty() {
        return this.keys.isEmpty();
    }

    @Override
    public Set<K> keySet() {
        return this.keys.keySet();
    }

    @Override
    public V put(K key, V value) {
        ArrayList<Long> ids = this.keys.get(key);
        if (ids == null) {
            ids = new ArrayList();
            ids.add(this.id);
            this.keys.put(key, ids);
        } else {
            ids.add(this.id);
        }
        this.values.put(this.id, value);
        ++this.id;
        return null;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> src) {
        for (Map.Entry<K, V> o : src.entrySet()) {
            this.put((K)((Comparable)o.getKey()), o.getValue());
        }
    }

    @Override
    public V remove(Object key) {
        ArrayList<Long> l = this.keys.get(key);
        if (l == null) {
            return null;
        }
        V old = this.values.remove(l.remove(0));
        if (l.isEmpty()) {
            this.keys.remove(key);
        }
        return old;
    }

    @Override
    public int size() {
        return this.values.size();
    }

    @Override
    public Collection<V> values() {
        return this.values.values();
    }

    public class MultiMapEntrySet
    implements Set<Map.Entry<K, V>>,
    Iterator<Map.Entry<K, V>> {
        private MultiMap<K, V> map;
        private Iterator<Map.Entry<K, ArrayList<Long>>> it;
        private Iterator<Long> iit;
        private K key;
        private long id;

        public MultiMapEntrySet(MultiMap<K, V> map) {
            this.map = map;
        }

        @Override
        public boolean add(Map.Entry<K, V> arg0) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(Collection<? extends Map.Entry<K, V>> arg0) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean contains(Object arg0) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean containsAll(Collection<?> arg0) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isEmpty() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            this.it = this.map.keys.entrySet().iterator();
            return this;
        }

        @Override
        public boolean remove(Object arg0) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeAll(Collection<?> arg0) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(Collection<?> arg0) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int size() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Object[] toArray() {
            throw new UnsupportedOperationException();
        }

        @Override
        public <T> T[] toArray(T[] arg0) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean hasNext() {
            if (this.iit == null || !this.iit.hasNext()) {
                if (!this.it.hasNext()) {
                    return false;
                }
                Map.Entry item = this.it.next();
                this.key = (Comparable)item.getKey();
                this.iit = item.getValue().iterator();
            }
            return true;
        }

        @Override
        public Map.Entry<K, V> next() {
            this.id = this.iit.next();
            return new MultiMapEntry(MultiMap.this, this.key, this.map.values.get(this.id));
        }

        @Override
        public void remove() {
            this.iit.remove();
            this.map.values.remove(this.id);
            if (((ArrayList)this.map.keys.get(this.key)).isEmpty()) {
                this.it.remove();
            }
        }
    }

    public static class MultiMapEntry
    implements Map.Entry<K, V> {
        private K key;
        private V value;
        final /* synthetic */ MultiMap this$0;

        public MultiMapEntry(K key, V value) {
            this.this$0 = this$0;
            this.key = key;
            this.value = value;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public V setValue(V value) {
            Object old = this.value;
            this.value = value;
            return old;
        }
    }
}

