/*
 * Decompiled with CFR 0.152.
 */
package zmq;

import java.io.Closeable;
import java.io.IOException;
import java.nio.channels.SelectableChannel;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import zmq.Command;
import zmq.Config;
import zmq.Signaler;
import zmq.YPipe;

public class Mailbox
implements Closeable {
    private final YPipe<Command> cpipe = new YPipe(Config.COMMAND_PIPE_GRANULARITY.getValue());
    private final Signaler signaler;
    private final Lock sync = new ReentrantLock();
    private boolean active;
    private final String name;

    public Mailbox(String name) {
        this.signaler = new Signaler();
        Command cmd = this.cpipe.read();
        assert (cmd == null);
        this.active = false;
        this.name = name;
    }

    public SelectableChannel getFd() {
        return this.signaler.getFd();
    }

    public void send(Command cmd) {
        boolean ok = false;
        this.sync.lock();
        try {
            this.cpipe.write(cmd, false);
            ok = this.cpipe.flush();
        }
        finally {
            this.sync.unlock();
        }
        if (!ok) {
            this.signaler.send();
        }
    }

    public Command recv(long timeout) {
        boolean rc;
        Command cmd = null;
        if (this.active) {
            cmd = this.cpipe.read();
            if (cmd != null) {
                return cmd;
            }
            this.active = false;
            this.signaler.recv();
        }
        if (!(rc = this.signaler.waitEvent(timeout))) {
            return null;
        }
        this.active = true;
        cmd = this.cpipe.read();
        assert (cmd != null);
        return cmd;
    }

    @Override
    public void close() throws IOException {
        this.sync.lock();
        this.sync.unlock();
        this.signaler.close();
    }

    public String toString() {
        return super.toString() + "[" + this.name + "]";
    }
}

