/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.util;

import java.util.Collection;
import org.jetbrains.annotations.Nullable;

public class GridArgumentCheck {
    public static final String NULL_MSG_PREFIX = "Ouch! Argument cannot be null: ";
    private static final String INVALID_ARG_MSG_PREFIX = "Ouch! Argument is invalid: ";
    private static final String NOT_EMPTY_SUFFIX = " must not be empty.";
    private static final String NOT_NULL_OR_EMPTY_SUFFIX = " must not be null or empty.";

    public static void notNull(@Nullable Object val, String name) {
        if (val == null) {
            throw new NullPointerException(NULL_MSG_PREFIX + name);
        }
    }

    public static void notNull(Object val1, String name1, Object val2, String name2) {
        GridArgumentCheck.notNull(val1, name1);
        GridArgumentCheck.notNull(val2, name2);
    }

    public static void notNull(Object val1, String name1, Object val2, String name2, Object val3, String name3) {
        GridArgumentCheck.notNull(val1, name1);
        GridArgumentCheck.notNull(val2, name2);
        GridArgumentCheck.notNull(val3, name3);
    }

    public static void notNull(Object val1, String name1, Object val2, String name2, Object val3, String name3, Object val4, String name4) {
        GridArgumentCheck.notNull(val1, name1);
        GridArgumentCheck.notNull(val2, name2);
        GridArgumentCheck.notNull(val3, name3);
        GridArgumentCheck.notNull(val4, name4);
    }

    public static void ensure(boolean cond, String desc) {
        if (!cond) {
            throw new IllegalArgumentException(INVALID_ARG_MSG_PREFIX + desc);
        }
    }

    public static void notEmpty(Collection<?> c, String name) {
        GridArgumentCheck.notNull(c, name);
        if (c.isEmpty()) {
            throw new IllegalArgumentException(INVALID_ARG_MSG_PREFIX + name + NOT_EMPTY_SUFFIX);
        }
    }

    public static void notEmpty(Object[] arr, String name) {
        GridArgumentCheck.notNull(arr, name);
        if (arr.length == 0) {
            throw new IllegalArgumentException(INVALID_ARG_MSG_PREFIX + name + NOT_EMPTY_SUFFIX);
        }
    }

    public static void notEmpty(int[] arr, String name) {
        GridArgumentCheck.notNull(arr, name);
        if (arr.length == 0) {
            throw new IllegalArgumentException(INVALID_ARG_MSG_PREFIX + name + NOT_EMPTY_SUFFIX);
        }
    }

    public static void notEmpty(double[] arr, String name) {
        GridArgumentCheck.notNull(arr, name);
        if (arr.length == 0) {
            throw new IllegalArgumentException(INVALID_ARG_MSG_PREFIX + name + NOT_EMPTY_SUFFIX);
        }
    }

    public static void notNullOrEmpty(String value, String name) {
        GridArgumentCheck.notNull(value, name);
        if (value.trim().isEmpty()) {
            throw new IllegalArgumentException(INVALID_ARG_MSG_PREFIX + name + NOT_NULL_OR_EMPTY_SUFFIX);
        }
    }
}

