/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.odbc.jdbc;

import java.util.HashSet;
import java.util.Set;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.binary.BinaryReaderExImpl;
import org.apache.ignite.internal.processors.authentication.AuthorizationContext;
import org.apache.ignite.internal.processors.odbc.ClientListenerAbstractConnectionContext;
import org.apache.ignite.internal.processors.odbc.ClientListenerMessageParser;
import org.apache.ignite.internal.processors.odbc.ClientListenerProtocolVersion;
import org.apache.ignite.internal.processors.odbc.ClientListenerRequestHandler;
import org.apache.ignite.internal.processors.odbc.ClientListenerResponse;
import org.apache.ignite.internal.processors.odbc.ClientListenerResponseSender;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcMessageParser;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcRequestHandler;
import org.apache.ignite.internal.processors.query.NestedTxMode;
import org.apache.ignite.internal.util.GridSpinBusyLock;
import org.apache.ignite.internal.util.nio.GridNioSession;
import org.apache.ignite.internal.util.typedef.F;

public class JdbcConnectionContext
extends ClientListenerAbstractConnectionContext {
    private static final ClientListenerProtocolVersion VER_2_1_0 = ClientListenerProtocolVersion.create(2, 1, 0);
    private static final ClientListenerProtocolVersion VER_2_1_5 = ClientListenerProtocolVersion.create(2, 1, 5);
    static final ClientListenerProtocolVersion VER_2_3_0 = ClientListenerProtocolVersion.create(2, 3, 0);
    static final ClientListenerProtocolVersion VER_2_4_0 = ClientListenerProtocolVersion.create(2, 4, 0);
    static final ClientListenerProtocolVersion VER_2_5_0 = ClientListenerProtocolVersion.create(2, 5, 0);
    static final ClientListenerProtocolVersion VER_2_7_0;
    private static final ClientListenerProtocolVersion CURRENT_VER;
    private static final Set<ClientListenerProtocolVersion> SUPPORTED_VERS;
    private final GridNioSession ses;
    private final GridSpinBusyLock busyLock;
    private final IgniteLogger log;
    private final int maxCursors;
    private JdbcMessageParser parser = null;
    private JdbcRequestHandler handler = null;

    public JdbcConnectionContext(GridKernalContext ctx, GridNioSession ses, GridSpinBusyLock busyLock, long connId, int maxCursors) {
        super(ctx, connId);
        this.ses = ses;
        this.busyLock = busyLock;
        this.maxCursors = maxCursors;
        this.log = ctx.log(this.getClass());
    }

    @Override
    public boolean isVersionSupported(ClientListenerProtocolVersion ver) {
        return SUPPORTED_VERS.contains(ver);
    }

    @Override
    public ClientListenerProtocolVersion currentVersion() {
        return CURRENT_VER;
    }

    @Override
    public void initializeFromHandshake(ClientListenerProtocolVersion ver, BinaryReaderExImpl reader) throws IgniteCheckedException {
        String nestedTxModeName;
        assert (SUPPORTED_VERS.contains(ver)) : "Unsupported JDBC protocol version.";
        boolean distributedJoins = reader.readBoolean();
        boolean enforceJoinOrder = reader.readBoolean();
        boolean collocated = reader.readBoolean();
        boolean replicatedOnly = reader.readBoolean();
        boolean autoCloseCursors = reader.readBoolean();
        boolean lazyExec = false;
        boolean skipReducerOnUpdate = false;
        NestedTxMode nestedTxMode = NestedTxMode.DEFAULT;
        AuthorizationContext actx = null;
        if (ver.compareTo(VER_2_1_5) >= 0) {
            lazyExec = reader.readBoolean();
        }
        if (ver.compareTo(VER_2_3_0) >= 0) {
            skipReducerOnUpdate = reader.readBoolean();
        }
        if (ver.compareTo(VER_2_7_0) >= 0 && !F.isEmpty(nestedTxModeName = reader.readString())) {
            try {
                nestedTxMode = NestedTxMode.valueOf(nestedTxModeName);
            }
            catch (IllegalArgumentException e) {
                throw new IgniteCheckedException("Invalid nested transactions handling mode: " + nestedTxModeName);
            }
        }
        if (ver.compareTo(VER_2_5_0) >= 0) {
            String user = null;
            String passwd = null;
            try {
                if (reader.available() > 0) {
                    user = reader.readString();
                    passwd = reader.readString();
                }
            }
            catch (Exception e) {
                throw new IgniteCheckedException("Handshake error: " + e.getMessage(), e);
            }
            actx = this.authenticate(user, passwd);
        }
        this.parser = new JdbcMessageParser(this.ctx, ver);
        ClientListenerResponseSender sender = new ClientListenerResponseSender(){

            @Override
            public void send(ClientListenerResponse resp) {
                if (resp != null) {
                    if (JdbcConnectionContext.this.log.isDebugEnabled()) {
                        JdbcConnectionContext.this.log.debug("Async response: [resp=" + resp.status() + ']');
                    }
                    byte[] outMsg = JdbcConnectionContext.this.parser.encode(resp);
                    JdbcConnectionContext.this.ses.send(outMsg);
                }
            }
        };
        this.handler = new JdbcRequestHandler(this.ctx, this.busyLock, sender, this.maxCursors, distributedJoins, enforceJoinOrder, collocated, replicatedOnly, autoCloseCursors, lazyExec, skipReducerOnUpdate, nestedTxMode, actx, ver);
        this.handler.start();
    }

    @Override
    public ClientListenerRequestHandler handler() {
        return this.handler;
    }

    @Override
    public ClientListenerMessageParser parser() {
        return this.parser;
    }

    @Override
    public void onDisconnected() {
        this.handler.onDisconnect();
    }

    static {
        CURRENT_VER = VER_2_7_0 = ClientListenerProtocolVersion.create(2, 7, 0);
        SUPPORTED_VERS = new HashSet<ClientListenerProtocolVersion>();
        SUPPORTED_VERS.add(CURRENT_VER);
        SUPPORTED_VERS.add(VER_2_7_0);
        SUPPORTED_VERS.add(VER_2_5_0);
        SUPPORTED_VERS.add(VER_2_4_0);
        SUPPORTED_VERS.add(VER_2_3_0);
        SUPPORTED_VERS.add(VER_2_1_5);
        SUPPORTED_VERS.add(VER_2_1_0);
    }
}

