/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.client.thin;

import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.client.ClientConnectionException;
import org.apache.ignite.client.ClientException;
import org.apache.ignite.configuration.ClientConfiguration;
import org.apache.ignite.internal.binary.streams.BinaryInputStream;
import org.apache.ignite.internal.binary.streams.BinaryOutputStream;
import org.apache.ignite.internal.client.thin.ClientChannel;
import org.apache.ignite.internal.client.thin.ClientChannelConfiguration;
import org.apache.ignite.internal.client.thin.ClientOperation;
import org.apache.ignite.internal.client.thin.ProtocolVersion;
import org.apache.ignite.internal.client.thin.Result;
import org.apache.ignite.internal.util.HostAndPortRange;

final class ReliableChannel
implements AutoCloseable {
    private final Function<ClientChannelConfiguration, Result<ClientChannel>> chFactory;
    private final Lock svcLock = new ReentrantLock();
    private InetSocketAddress primary;
    private final Deque<InetSocketAddress> backups = new LinkedList<InetSocketAddress>();
    private ClientChannel ch = null;
    private final ClientConfiguration clientCfg;

    ReliableChannel(Function<ClientChannelConfiguration, Result<ClientChannel>> chFactory, ClientConfiguration clientCfg) throws ClientException {
        if (chFactory == null) {
            throw new NullPointerException("chFactory");
        }
        if (clientCfg == null) {
            throw new NullPointerException("clientCfg");
        }
        this.chFactory = chFactory;
        this.clientCfg = clientCfg;
        List<InetSocketAddress> addrs = ReliableChannel.parseAddresses(clientCfg.getAddresses());
        this.primary = addrs.get(new Random().nextInt(addrs.size()));
        this.ch = chFactory.apply(new ClientChannelConfiguration(clientCfg).setAddress(this.primary)).get();
        for (InetSocketAddress a : addrs) {
            if (a == this.primary) continue;
            this.backups.add(a);
        }
    }

    @Override
    public void close() throws Exception {
        if (this.ch != null) {
            this.ch.close();
            this.ch = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T service(ClientOperation op, Consumer<BinaryOutputStream> payloadWriter, Function<BinaryInputStream, T> payloadReader) throws ClientException {
        ClientConnectionException failure = null;
        T res = null;
        int totalSrvs = 1 + this.backups.size();
        this.svcLock.lock();
        try {
            for (int i = 0; i < totalSrvs; ++i) {
                try {
                    if (failure != null) {
                        this.changeServer();
                    }
                    if (this.ch == null) {
                        this.ch = this.chFactory.apply(new ClientChannelConfiguration(this.clientCfg).setAddress(this.primary)).get();
                    }
                    long id = this.ch.send(op, payloadWriter);
                    res = this.ch.receive(op, id, payloadReader);
                    failure = null;
                    break;
                }
                catch (ClientConnectionException e) {
                    if (failure == null) {
                        failure = e;
                        continue;
                    }
                    failure.addSuppressed(e);
                    continue;
                }
            }
        }
        finally {
            this.svcLock.unlock();
        }
        if (failure != null) {
            throw failure;
        }
        return res;
    }

    public <T> T service(ClientOperation op, Function<BinaryInputStream, T> payloadReader) throws ClientException {
        return this.service(op, null, payloadReader);
    }

    public void request(ClientOperation op, Consumer<BinaryOutputStream> payloadWriter) throws ClientException {
        this.service(op, payloadWriter, null);
    }

    public ProtocolVersion serverVersion() {
        return this.ch.serverVersion();
    }

    private static List<InetSocketAddress> parseAddresses(String[] addrs) throws ClientException {
        ArrayList<HostAndPortRange> ranges = new ArrayList<HostAndPortRange>(addrs.length);
        for (String a : addrs) {
            try {
                ranges.add(HostAndPortRange.parse(a, 10800, 10900, "Failed to parse Ignite server address"));
            }
            catch (IgniteCheckedException e) {
                throw new ClientException(e);
            }
        }
        return ranges.stream().flatMap(r -> IntStream.rangeClosed(r.portFrom(), r.portTo()).boxed().map(p -> new InetSocketAddress(r.host(), (int)p))).collect(Collectors.toList());
    }

    private void changeServer() {
        if (!this.backups.isEmpty()) {
            this.backups.addLast(this.primary);
            this.primary = this.backups.removeFirst();
            try {
                this.ch.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.ch = null;
        }
    }
}

