/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.failure;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.failure.AbstractFailureHandler;
import org.apache.ignite.failure.FailureContext;
import org.apache.ignite.internal.IgnitionEx;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;

public class StopNodeOrHaltFailureHandler
extends AbstractFailureHandler {
    private final boolean tryStop;
    private final long timeout;

    public StopNodeOrHaltFailureHandler() {
        this(false, 0L);
    }

    public StopNodeOrHaltFailureHandler(boolean tryStop, long timeout) {
        this.tryStop = tryStop;
        this.timeout = timeout;
    }

    @Override
    protected boolean handle(final Ignite ignite, final FailureContext failureCtx) {
        final IgniteLogger log = ignite.log();
        if (this.tryStop) {
            final CountDownLatch latch = new CountDownLatch(1);
            new Thread(new Runnable(){

                @Override
                public void run() {
                    U.error(log, "Stopping local node on Ignite failure: [failureCtx=" + failureCtx + ']');
                    IgnitionEx.stop(ignite.name(), true, true);
                    latch.countDown();
                }
            }, "node-stopper").start();
            new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        if (!latch.await(StopNodeOrHaltFailureHandler.this.timeout, TimeUnit.MILLISECONDS)) {
                            U.error(log, "Stopping local node timeout, JVM will be halted.");
                            Runtime.getRuntime().halt(130);
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }, "jvm-halt-on-stop-timeout").start();
        } else {
            U.error(log, "JVM will be halted immediately due to the failure: [failureCtx=" + failureCtx + ']');
            Runtime.getRuntime().halt(130);
        }
        return true;
    }

    public long timeout() {
        return this.timeout;
    }

    public boolean tryStop() {
        return this.tryStop;
    }

    @Override
    public String toString() {
        return S.toString(StopNodeOrHaltFailureHandler.class, this, "super", super.toString());
    }
}

