/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.yardstick.thin.cache;

import java.util.Map;
import org.apache.ignite.client.ClientCache;
import org.apache.ignite.yardstick.cache.model.SampleValue;
import org.apache.ignite.yardstick.thin.cache.IgniteThinCacheAbstractBenchmark;
import org.yardstickframework.BenchmarkConfiguration;
import org.yardstickframework.BenchmarkUtils;

public class IgniteThinGetBenchmark
extends IgniteThinCacheAbstractBenchmark<Integer, Object> {
    @Override
    public void setUp(BenchmarkConfiguration cfg) throws Exception {
        super.setUp(cfg);
        if (this.args.preloadAmount() > this.args.range()) {
            throw new IllegalArgumentException("Preloading amount (\"-pa\", \"--preloadAmount\") must by less then the range (\"-r\", \"--range\").");
        }
        this.loadSampleValues(this.cache().getName(), this.args.preloadAmount());
    }

    public boolean test(Map<Object, Object> ctx) throws Exception {
        int key = IgniteThinGetBenchmark.nextRandom(this.args.range());
        this.cache().get((Object)key);
        return true;
    }

    @Override
    protected ClientCache<Integer, Object> cache() {
        return this.client().cache("atomic");
    }

    private void loadSampleValues(String cacheName, int cnt) {
        for (int i = 0; i < cnt; ++i) {
            this.cache.put((Object)i, (Object)new SampleValue(i));
            if (i % 100000 != 0) continue;
            if (Thread.currentThread().isInterrupted()) break;
            BenchmarkUtils.println((String)("Loaded entries [cache=" + cacheName + ", cnt=" + i + ']'));
        }
        BenchmarkUtils.println((String)("Load entries done [cache=" + cacheName + ", cnt=" + cnt + ']'));
    }
}

