/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.yardstick.jdbc.mvcc;

import java.util.Map;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.ignite.cache.CacheAtomicityMode;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.internal.processors.query.IgniteSQLException;
import org.apache.ignite.yardstick.jdbc.mvcc.AbstractDistributedMvccBenchmark;
import org.yardstickframework.BenchmarkUtils;

public class MvccUpdateContentionBenchmark
extends AbstractDistributedMvccBenchmark {
    private static final String MVCC_EXC_MSG = "Cannot serialize transaction due to write conflict";
    private static final String NO_MVCC_EXC_MSG_PREFIX = "Failed to UPDATE some keys because they had been modified concurrently";
    private final AtomicLong failsCnt = new AtomicLong();

    public boolean test(Map<Object, Object> ctx) throws Exception {
        ThreadLocalRandom rnd = ThreadLocalRandom.current();
        long start = rnd.nextLong(this.args.mvccContentionRange() - (long)(this.args.sqlRange() - 1)) + 1L;
        long end = start + (long)(this.args.sqlRange() - 1);
        try {
            this.execute(new SqlFieldsQuery("UPDATE test_long SET val = (val + 1) WHERE id BETWEEN ? AND ?").setArgs(new Object[]{start, end}));
        }
        catch (IgniteSQLException exc) {
            if (this.args.atomicMode() == CacheAtomicityMode.TRANSACTIONAL_SNAPSHOT && !exc.getMessage().startsWith(MVCC_EXC_MSG) || this.args.atomicMode() != CacheAtomicityMode.TRANSACTIONAL_SNAPSHOT && !exc.getMessage().startsWith(NO_MVCC_EXC_MSG_PREFIX)) {
                throw new RuntimeException("Exception with unexpected message is thrown.", exc);
            }
            this.failsCnt.incrementAndGet();
        }
        catch (Exception e) {
            throw new RuntimeException("Could not perform update.", e);
        }
        return true;
    }

    @Override
    public void tearDown() throws Exception {
        try {
            super.tearDown();
        }
        finally {
            BenchmarkUtils.println((String)("Update contention count : " + this.failsCnt.get()));
        }
    }
}

