/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.yardstick.cache.model;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.ignite.binary.BinaryObjectException;
import org.apache.ignite.binary.BinaryReader;
import org.apache.ignite.binary.BinaryWriter;
import org.apache.ignite.binary.Binarylizable;
import org.apache.ignite.cache.query.annotations.QuerySqlField;

public class Person
implements Externalizable,
Binarylizable {
    @QuerySqlField(index=true)
    private int id;
    @QuerySqlField(index=true)
    private int orgId;
    @QuerySqlField
    private String firstName;
    @QuerySqlField
    private String lastName;
    @QuerySqlField(index=true)
    private double salary;

    public Person() {
    }

    public Person(int id, String firstName, String lastName, double salary) {
        this(id, 0, firstName, lastName, salary);
    }

    public Person(int id, int orgId, String firstName, String lastName, double salary) {
        this.id = id;
        this.orgId = orgId;
        this.firstName = firstName;
        this.lastName = lastName;
        this.salary = salary;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public int getOrganizationId() {
        return this.orgId;
    }

    public void setOrganizationId(int orgId) {
        this.orgId = orgId;
    }

    public String getFirstName() {
        return this.firstName;
    }

    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    public String getLastName() {
        return this.lastName;
    }

    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    public double getSalary() {
        return this.salary;
    }

    public void setSalary(double salary) {
        this.salary = salary;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.id);
        out.writeInt(this.orgId);
        out.writeUTF(this.firstName);
        out.writeUTF(this.lastName);
        out.writeDouble(this.salary);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.id = in.readInt();
        this.orgId = in.readInt();
        this.firstName = in.readUTF();
        this.lastName = in.readUTF();
        this.salary = in.readDouble();
    }

    public void writeBinary(BinaryWriter writer) throws BinaryObjectException {
        writer.writeInt("id", this.id);
        writer.writeInt("orgId", this.orgId);
        writer.writeString("firstName", this.firstName);
        writer.writeString("lastName", this.lastName);
        writer.writeDouble("salary", this.salary);
    }

    public void readBinary(BinaryReader reader) throws BinaryObjectException {
        this.id = reader.readInt("id");
        this.orgId = reader.readInt("orgId");
        this.firstName = reader.readString("firstName");
        this.lastName = reader.readString("lastName");
        this.salary = reader.readDouble("salary");
    }

    public boolean equals(Object o) {
        return this == o || o instanceof Person && this.id == ((Person)o).id;
    }

    public int hashCode() {
        return this.id;
    }

    public String toString() {
        return "Person [firstName=" + this.firstName + ", id=" + this.id + ", orgId=" + this.orgId + ", lastName=" + this.lastName + ", salary=" + this.salary + ']';
    }
}

