/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.yardstick.cache.jdbc;

import java.util.Map;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicLong;
import javax.cache.processor.EntryProcessor;
import javax.cache.processor.EntryProcessorException;
import javax.cache.processor.MutableEntry;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.IgniteDataStreamer;
import org.apache.ignite.IgniteTransactions;
import org.apache.ignite.transactions.Transaction;
import org.apache.ignite.yardstick.IgniteAbstractBenchmark;
import org.apache.ignite.yardstick.cache.model.Accounts;
import org.apache.ignite.yardstick.cache.model.Branches;
import org.apache.ignite.yardstick.cache.model.History;
import org.apache.ignite.yardstick.cache.model.Tellers;
import org.yardstickframework.BenchmarkConfiguration;

public class IgniteNativeTxBenchmark
extends IgniteAbstractBenchmark {
    private long accRows;
    private long tellRows;
    private long branchRows;
    private IgniteCache<Long, Accounts> accounts;
    private IgniteCache<Long, Tellers> tellers;
    private IgniteCache<Long, Branches> branches;
    private IgniteCache<Long, History> hist;
    private AtomicLong cnt;

    @Override
    public void setUp(BenchmarkConfiguration cfg) throws Exception {
        super.setUp(cfg);
        this.cnt = new AtomicLong();
        this.accRows = 1000L * (long)this.args.scaleFactor();
        this.tellRows = 10L * (long)this.args.scaleFactor();
        this.branchRows = 5L * (long)this.args.scaleFactor();
        this.accounts = this.ignite().cache("Accounts");
        this.tellers = this.ignite().cache("Tellers");
        this.branches = this.ignite().cache("Branches");
        this.hist = this.ignite().cache("History");
        this.clearCaches();
        this.fillTables();
    }

    public boolean test(Map<Object, Object> ctx) throws Exception {
        long aid = ThreadLocalRandom.current().nextLong(this.accRows);
        long bid = ThreadLocalRandom.current().nextLong(this.branchRows);
        long tid = ThreadLocalRandom.current().nextLong(this.tellRows);
        final long delta = ThreadLocalRandom.current().nextLong(1000L);
        IgniteTransactions transactions = this.ignite().transactions();
        try (Transaction tx = transactions.txStart(this.args.txConcurrency(), this.args.txIsolation());){
            this.accounts.invoke((Object)aid, (EntryProcessor)new EntryProcessor<Long, Accounts, Object>(){

                public Long process(MutableEntry<Long, Accounts> entry, Object ... objects) throws EntryProcessorException {
                    long newVal = ((Accounts)entry.getValue()).getVal() + delta;
                    entry.setValue((Object)((Accounts)entry.getValue()).setVal(newVal));
                    return newVal;
                }
            }, new Object[0]);
            this.tellers.invoke((Object)tid, (EntryProcessor)new EntryProcessor<Long, Tellers, Object>(){

                public Long process(MutableEntry<Long, Tellers> entry, Object ... objects) throws EntryProcessorException {
                    long newVal = ((Tellers)entry.getValue()).getVal() + delta;
                    entry.setValue((Object)((Tellers)entry.getValue()).setVal(newVal));
                    return null;
                }
            }, new Object[0]);
            this.branches.invoke((Object)bid, (EntryProcessor)new EntryProcessor<Long, Branches, Object>(){

                public Long process(MutableEntry<Long, Branches> entry, Object ... objects) throws EntryProcessorException {
                    long newVal = ((Branches)entry.getValue()).getVal() + delta;
                    entry.setValue((Object)((Branches)entry.getValue()).setVal(newVal));
                    return null;
                }
            }, new Object[0]);
            this.hist.put((Object)this.cnt.getAndIncrement(), (Object)new History(tid, bid, aid, delta));
            tx.commit();
        }
        return true;
    }

    private void fillTables() throws Exception {
        long i;
        this.startPreloadLogging(this.args.preloadLogsInterval());
        try (IgniteDataStreamer dataLdr = this.ignite().dataStreamer(this.accounts.getName());){
            for (i = 0L; i < this.accRows; ++i) {
                dataLdr.addData((Object)i, (Object)new Accounts(IgniteNativeTxBenchmark.nextRandom(this.args.range())));
            }
        }
        dataLdr = this.ignite().dataStreamer(this.branches.getName());
        var2_2 = null;
        try {
            for (i = 0L; i < this.branchRows; ++i) {
                dataLdr.addData((Object)i, (Object)new Branches(IgniteNativeTxBenchmark.nextRandom(this.args.range())));
            }
        }
        catch (Throwable i2) {
            var2_2 = i2;
            throw i2;
        }
        finally {
            if (dataLdr != null) {
                if (var2_2 != null) {
                    try {
                        dataLdr.close();
                    }
                    catch (Throwable i2) {
                        var2_2.addSuppressed(i2);
                    }
                } else {
                    dataLdr.close();
                }
            }
        }
        dataLdr = this.ignite().dataStreamer(this.tellers.getName());
        var2_2 = null;
        try {
            for (long i3 = 0L; i3 < this.tellRows; ++i3) {
                dataLdr.addData((Object)i3, (Object)new Tellers(IgniteNativeTxBenchmark.nextRandom(this.args.range())));
            }
        }
        catch (Throwable throwable) {
            var2_2 = throwable;
            throw throwable;
        }
        finally {
            if (dataLdr != null) {
                if (var2_2 != null) {
                    try {
                        dataLdr.close();
                    }
                    catch (Throwable throwable) {
                        var2_2.addSuppressed(throwable);
                    }
                } else {
                    dataLdr.close();
                }
            }
        }
        this.stopPreloadLogging();
    }

    private void clearCaches() {
        this.ignite().cache("Accounts").clear();
        this.ignite().cache("Tellers").clear();
        this.ignite().cache("Branches").clear();
        this.ignite().cache("History").clear();
    }
}

