/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.yardstick.cache.failover;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.Callable;
import org.apache.ignite.transactions.TransactionConcurrency;
import org.apache.ignite.transactions.TransactionIsolation;
import org.apache.ignite.yardstick.IgniteBenchmarkUtils;
import org.apache.ignite.yardstick.cache.failover.IgniteConsistencyException;
import org.apache.ignite.yardstick.cache.failover.IgniteFailoverAbstractBenchmark;
import org.yardstickframework.BenchmarkConfiguration;
import org.yardstickframework.BenchmarkUtils;

public class IgniteTransactionalWriteReadBenchmark
extends IgniteFailoverAbstractBenchmark<String, Long> {
    public boolean test(Map<Object, Object> ctx) throws Exception {
        int k = IgniteTransactionalWriteReadBenchmark.nextRandom(this.args.range());
        assert (this.args.keysCount() > 0) : "Count of keys: " + this.args.keysCount();
        final String[] keys = new String[this.args.keysCount()];
        for (int i = 0; i < keys.length; ++i) {
            keys[i] = "key-" + k + "-" + i;
        }
        return IgniteBenchmarkUtils.doInTransaction(this.ignite().transactions(), TransactionConcurrency.PESSIMISTIC, TransactionIsolation.REPEATABLE_READ, new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                Long val;
                HashMap<String, Long> map = new HashMap<String, Long>();
                int timeout = IgniteTransactionalWriteReadBenchmark.this.args.cacheOperationTimeoutMillis();
                for (String key : keys) {
                    val = (Long)IgniteTransactionalWriteReadBenchmark.this.cache.getAsync((Object)key).get((long)timeout);
                    map.put(key, val);
                }
                HashSet values = new HashSet(map.values());
                if (values.size() != 1) {
                    BenchmarkUtils.println((BenchmarkConfiguration)IgniteTransactionalWriteReadBenchmark.this.cfg, (String)("Got different values for keys [map=" + map + "]"));
                    BenchmarkUtils.println((BenchmarkConfiguration)IgniteTransactionalWriteReadBenchmark.this.cfg, (String)"Cache content:");
                    for (int k = 0; k < IgniteTransactionalWriteReadBenchmark.this.args.range(); ++k) {
                        for (int i = 0; i < IgniteTransactionalWriteReadBenchmark.this.args.keysCount(); ++i) {
                            String key;
                            key = "key-" + k + "-" + i;
                            val = (Long)IgniteTransactionalWriteReadBenchmark.this.cache.getAsync((Object)key).get((long)timeout);
                            if (val == null) continue;
                            BenchmarkUtils.println((BenchmarkConfiguration)IgniteTransactionalWriteReadBenchmark.this.cfg, (String)("Entry [key=" + key + ", val=" + val + "]"));
                        }
                    }
                    throw new IgniteConsistencyException("Found different values for keys (see above information).");
                }
                Long oldVal = (Long)map.get(keys[0]);
                Long newVal = oldVal == null ? 0L : oldVal + 1L;
                for (String key : keys) {
                    IgniteTransactionalWriteReadBenchmark.this.cache.putAsync((Object)key, (Object)newVal).get((long)timeout);
                }
                return true;
            }
        });
    }

    @Override
    protected String cacheName() {
        return "tx-write-read";
    }
}

