/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.yardstick.cache.failover;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.cache.Cache;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cluster.ClusterGroup;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.internal.IgniteKernal;
import org.apache.ignite.internal.processors.cache.GridCacheAdapter;
import org.apache.ignite.internal.processors.cache.IgniteInternalCache;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtCacheAdapter;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.GridDhtPartitionFullMap;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.GridDhtPartitionMap;
import org.apache.ignite.internal.processors.cache.distributed.dht.topology.GridDhtPartitionState;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteRunnable;
import org.apache.ignite.mxbean.IgniteMXBean;
import org.apache.ignite.resources.IgniteInstanceResource;
import org.apache.ignite.yardstick.cache.IgniteCacheAbstractBenchmark;
import org.yardstickframework.BenchmarkConfiguration;
import org.yardstickframework.BenchmarkUtils;

public abstract class IgniteFailoverAbstractBenchmark<K, V>
extends IgniteCacheAbstractBenchmark<K, V> {
    private static final AtomicBoolean restarterStarted = new AtomicBoolean();
    private final AtomicBoolean firtsExProcessed = new AtomicBoolean();

    @Override
    public void setUp(BenchmarkConfiguration cfg) throws Exception {
        super.setUp(cfg);
    }

    public void onWarmupFinished() {
        if (this.cfg.memberId() == 0 && restarterStarted.compareAndSet(false, true)) {
            Thread restarterThread = new Thread(new Runnable(){

                @Override
                public void run() {
                    block8: {
                        try {
                            BenchmarkUtils.println((String)("Servers restarter started on driver: " + ((Object)((Object)IgniteFailoverAbstractBenchmark.this)).getClass().getSimpleName()));
                            Ignite ignite = IgniteFailoverAbstractBenchmark.this.ignite();
                            IgniteCache srvsCfgsCache = ignite.getOrCreateCache(new CacheConfiguration().setName("serversConfigs"));
                            HashMap<Object, Object> srvsCfgs = new HashMap<Object, Object>();
                            for (Cache.Entry e : srvsCfgsCache) {
                                BenchmarkUtils.println((String)("Read entry from 'serversConfigs' cache : " + e));
                                srvsCfgs.put(e.getKey(), e.getValue());
                            }
                            assert (ignite.cluster().forServers().nodes().size() == srvsCfgs.size());
                            int backupsCnt = IgniteFailoverAbstractBenchmark.this.args.backups();
                            assert (backupsCnt >= 1) : "Backups: " + backupsCnt;
                            boolean isDebug = ignite.log().isDebugEnabled();
                            while (!Thread.currentThread().isInterrupted()) {
                                BenchmarkUtils.ProcessExecutionResult res;
                                BenchmarkConfiguration bc;
                                Integer id;
                                int i;
                                Thread.sleep(IgniteFailoverAbstractBenchmark.this.args.restartDelay() * 1000);
                                int numNodesToRestart = IgniteFailoverAbstractBenchmark.this.nextRandom(1, backupsCnt + 1);
                                ArrayList ids = new ArrayList();
                                ids.addAll(srvsCfgs.keySet());
                                Collections.shuffle(ids);
                                BenchmarkUtils.println((String)"Waiting for partitioned map exchage of all nodes");
                                ignite.compute().broadcastAsync((IgniteRunnable)new AwaitPartitionMapExchangeTask()).get((long)IgniteFailoverAbstractBenchmark.this.args.cacheOperationTimeoutMillis());
                                BenchmarkUtils.println((String)("Start servers restarting [numNodesToRestart=" + numNodesToRestart + ", shuffledIds=" + ids + "]"));
                                for (i = 0; i < numNodesToRestart; ++i) {
                                    id = (Integer)ids.get(i);
                                    bc = (BenchmarkConfiguration)srvsCfgs.get(id);
                                    res = BenchmarkUtils.kill9Server((BenchmarkConfiguration)bc, (boolean)isDebug);
                                    BenchmarkUtils.println((String)("Server with id " + id + " has been killed." + (isDebug ? " Process execution result:\n" + res : "")));
                                }
                                Thread.sleep(IgniteFailoverAbstractBenchmark.this.args.restartSleep() * 1000);
                                for (i = 0; i < numNodesToRestart; ++i) {
                                    id = (Integer)ids.get(i);
                                    bc = (BenchmarkConfiguration)srvsCfgs.get(id);
                                    res = BenchmarkUtils.startServer((BenchmarkConfiguration)bc, (boolean)isDebug);
                                    BenchmarkUtils.println((String)("Server with id " + id + " has been started." + (isDebug ? " Process execution result:\n" + res : "")));
                                }
                            }
                        }
                        catch (Throwable e) {
                            BenchmarkUtils.println((String)("Got exception: " + e));
                            e.printStackTrace();
                            U.dumpThreads(null);
                            if (!(e instanceof Error)) break block8;
                            throw (Error)e;
                        }
                    }
                }
            }, "servers-restarter");
            restarterThread.setDaemon(true);
            restarterThread.start();
        }
    }

    protected static void awaitPartitionMapExchange(Ignite ignite) throws Exception {
        IgniteLogger log = ignite.log();
        log.info("Waiting for finishing of a partition exchange on node: " + ignite);
        IgniteKernal kernal = (IgniteKernal)ignite;
        while (true) {
            boolean partitionsExchangeFinished = true;
            for (IgniteInternalCache cache : kernal.cachesx(null)) {
                log.info("Checking cache: " + cache.name());
                GridCacheAdapter c = kernal.internalCache(cache.name());
                if (!(c instanceof GridDhtCacheAdapter)) break;
                GridDhtCacheAdapter dht = (GridDhtCacheAdapter)c;
                GridDhtPartitionFullMap partMap = dht.topology().partitionMap(true);
                for (Map.Entry e : partMap.entrySet()) {
                    log.info("Checking node: " + e.getKey());
                    for (Map.Entry e1 : ((GridDhtPartitionMap)e.getValue()).entrySet()) {
                        if (e1.getValue() == GridDhtPartitionState.OWNING) continue;
                        log.info("Undesired state [id=" + e1.getKey() + ", state=" + e1.getValue() + ']');
                        partitionsExchangeFinished = false;
                        break;
                    }
                    if (partitionsExchangeFinished) continue;
                    break;
                }
                if (partitionsExchangeFinished) continue;
                break;
            }
            if (partitionsExchangeFinished) {
                return;
            }
            Thread.sleep(100L);
        }
    }

    public void onException(Throwable e) {
        if (this.firtsExProcessed.compareAndSet(false, true)) {
            BenchmarkUtils.println((String)"Full thread dump of the current node below.");
            U.dumpThreads(null);
            BenchmarkUtils.println((String)"");
            ((IgniteMXBean)this.ignite()).dumpDebugInfo();
            Ignite ignite = this.ignite();
            ClusterGroup srvs = ignite.cluster().forServers();
            ignite.compute(srvs).broadcastAsync((IgniteRunnable)new ThreadDumpPrinterTask(ignite.cluster().localNode().id(), e)).get(10000L);
        }
    }

    protected abstract String cacheName();

    @Override
    protected IgniteCache<K, V> cache() {
        return this.ignite().cache(this.cacheName());
    }

    private static class AwaitPartitionMapExchangeTask
    implements IgniteRunnable {
        private static final long serialVersionUID = 0L;
        @IgniteInstanceResource
        private Ignite ignite;

        private AwaitPartitionMapExchangeTask() {
        }

        public void run() {
            try {
                IgniteFailoverAbstractBenchmark.awaitPartitionMapExchange(this.ignite);
            }
            catch (Exception e) {
                throw new IgniteException((Throwable)e);
            }
        }
    }

    private static class ThreadDumpPrinterTask
    implements IgniteRunnable {
        private static final long serialVersionUID = 0L;
        @IgniteInstanceResource
        private Ignite ignite;
        private final UUID id;
        private final Throwable e;

        ThreadDumpPrinterTask(UUID id, Throwable e) {
            this.id = id;
            this.e = e;
        }

        public void run() {
            BenchmarkUtils.println((String)("Driver finished with exception [driverNodeId=" + this.id + ", e=" + this.e + "]"));
            BenchmarkUtils.println((String)"Full thread dump of the current server node below.");
            U.dumpThreads(null);
            BenchmarkUtils.println((String)"");
            ((IgniteMXBean)this.ignite).dumpDebugInfo();
        }
    }
}

