/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.yardstick.cache.dml;

import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.yardstick.cache.IgniteCacheAbstractBenchmark;
import org.apache.ignite.yardstick.cache.model.Person1;
import org.yardstickframework.BenchmarkConfiguration;
import org.yardstickframework.BenchmarkUtils;

public class IgniteSqlDeleteBenchmark
extends IgniteCacheAbstractBenchmark<Integer, Object> {
    private final ConcurrentLinkedQueue<Integer> keys = new ConcurrentLinkedQueue();

    @Override
    public void setUp(final BenchmarkConfiguration cfg) throws Exception {
        super.setUp(cfg);
        final AtomicInteger i = new AtomicInteger();
        ArrayList<1> setupThreads = new ArrayList<1>(cfg.threads());
        for (int j = 0; j < cfg.threads(); ++j) {
            Thread thread = new Thread(){

                @Override
                public void run() {
                    int k;
                    while ((k = i.getAndIncrement()) < IgniteSqlDeleteBenchmark.this.args.range()) {
                        IgniteSqlDeleteBenchmark.this.cache().put((Object)k, (Object)new Person1(k));
                        IgniteSqlDeleteBenchmark.this.keys.add(k);
                        if (k % 100000 != 0) continue;
                        BenchmarkUtils.println((BenchmarkConfiguration)cfg, (String)("DELETE setUp: have successfully put " + k + " items"));
                    }
                }
            };
            setupThreads.add(thread);
            thread.start();
        }
        for (Thread thread : setupThreads) {
            thread.join();
        }
    }

    public boolean test(Map<Object, Object> ctx) throws Exception {
        this.cache.query(new SqlFieldsQuery("delete from Person1 where _key = ?").setArgs(new Object[]{this.keys.remove()}));
        return true;
    }

    @Override
    protected IgniteCache<Integer, Object> cache() {
        return this.ignite().cache("atomic-index");
    }
}

