/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.yardstick.cache;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.IgniteDataStreamer;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.yardstick.cache.IgniteCacheAbstractBenchmark;
import org.apache.ignite.yardstick.cache.model.Organization;
import org.apache.ignite.yardstick.cache.model.Person;
import org.yardstickframework.BenchmarkConfiguration;
import org.yardstickframework.BenchmarkUtils;

public class IgniteSqlQueryDistributedJoinBenchmark
extends IgniteCacheAbstractBenchmark<Integer, Object> {
    private int range;
    private boolean broadcast;

    @Override
    public void setUp(BenchmarkConfiguration cfg) throws Exception {
        super.setUp(cfg);
        this.broadcast = this.broadcastJoin();
        BenchmarkUtils.println((BenchmarkConfiguration)cfg, (String)"Populating query data...");
        this.range = this.args.range();
        if (this.range <= 0) {
            throw new IllegalArgumentException();
        }
        BenchmarkUtils.println((BenchmarkConfiguration)cfg, (String)("Populating join query data [orgCnt=" + this.range + ", personCnt=" + this.range + ", broadcastJoin=" + this.broadcast + "]"));
        this.loadCachesData();
        this.executeQueryJoin(0, this.broadcast, true);
    }

    @Override
    protected void loadCacheData(String cacheName) {
        try (IgniteDataStreamer dataLdr = this.ignite().dataStreamer(cacheName);){
            for (int orgId = 0; orgId < this.range; ++orgId) {
                dataLdr.addData((Object)orgId, (Object)new Organization(orgId, "org" + orgId));
                int personId = this.range + orgId;
                Person p = new Person(personId, orgId, "firstName" + personId, "lastName" + personId, 1000.0);
                dataLdr.addData((Object)personId, (Object)p);
                if (orgId % 1000 != 0 || !Thread.currentThread().isInterrupted()) continue;
                return;
            }
            dataLdr.close();
        }
    }

    protected boolean broadcastJoin() {
        return false;
    }

    public boolean test(Map<Object, Object> ctx) throws Exception {
        int orgId = IgniteSqlQueryDistributedJoinBenchmark.nextRandom(this.range);
        Collection<List<?>> res = this.executeQueryJoin(orgId, this.broadcast, false);
        int persons = 1;
        if (res.size() != persons) {
            throw new Exception("Invalid join result [orgId=" + orgId + ", resSize=" + res.size() + ']');
        }
        for (List<?> l : res) {
            int orgId0 = (Integer)l.get(1);
            if (orgId == orgId0) continue;
            throw new Exception("Invalid join result [orgId=" + orgId + ", res=" + l + ']');
        }
        return true;
    }

    private Collection<List<?>> executeQueryJoin(int orgId, boolean broadcast, boolean planOnly) throws Exception {
        String sql = broadcast ? "select p.id, p.orgId, p.firstName, p.lastName, o.name from Person p join Organization o on p.orgId = o.id where o.id=?" : "select p.id, p.orgId, p.firstName, p.lastName, o.name from Organization o join Person p on p.orgId = o._key where o._key=?";
        SqlFieldsQuery qry = new SqlFieldsQuery(planOnly ? "explain " + sql : sql);
        qry.setDistributedJoins(true);
        qry.setArgs(new Object[]{orgId});
        IgniteCache cache = this.cacheForOperation(true);
        if (planOnly) {
            String plan = (String)((List)cache.query(qry).getAll().get(0)).get(0);
            BenchmarkUtils.println((String)("Query execution plan:\n" + plan));
            if (broadcast ? plan.contains("batched:unicast") || !plan.contains("batched:broadcast") : !plan.contains("batched:unicast") || plan.contains("batched:broadcast")) {
                throw new Exception("Unexpected query plan: " + plan);
            }
            return null;
        }
        return cache.query(qry).getAll();
    }

    @Override
    protected IgniteCache<Integer, Object> cache() {
        return this.ignite().cache("query");
    }
}

