/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.yardstick;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.Ignition;
import org.apache.ignite.client.IgniteClient;
import org.apache.ignite.configuration.ClientConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.util.IgniteUtils;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteBiTuple;
import org.apache.ignite.yardstick.IgniteBenchmarkArguments;
import org.apache.ignite.yardstick.io.FileUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.xml.XmlBeanDefinitionReader;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.core.io.Resource;
import org.springframework.core.io.UrlResource;
import org.yardstickframework.BenchmarkConfiguration;
import org.yardstickframework.BenchmarkUtils;

public class IgniteThinClient {
    private IgniteClient client;

    public IgniteThinClient() {
    }

    public IgniteThinClient(IgniteClient client) {
        this.client = client;
    }

    public IgniteClient start(BenchmarkConfiguration cfg, String host) throws Exception {
        IgniteBenchmarkArguments args = new IgniteBenchmarkArguments();
        BenchmarkUtils.jcommander((String[])cfg.commandLineArguments(), (Object)args, (String)"<ignite-node>");
        IgniteBiTuple<IgniteConfiguration, ? extends ApplicationContext> tup = IgniteThinClient.loadConfiguration(args.configuration());
        IgniteConfiguration c = (IgniteConfiguration)tup.get1();
        assert (c != null);
        if (args.cleanWorkDirectory()) {
            FileUtils.cleanDirectory(U.workDirectory((String)c.getWorkDirectory(), (String)c.getIgniteHome()));
        }
        ClientConfiguration clCfg = new ClientConfiguration();
        String hostPort = host + ":10800";
        BenchmarkUtils.println((String)String.format("Using for connection address: %s", hostPort));
        clCfg.setAddresses(new String[]{hostPort});
        this.client = Ignition.startClient((ClientConfiguration)clCfg);
        return this.client;
    }

    private static IgniteBiTuple<IgniteConfiguration, ? extends ApplicationContext> loadConfiguration(String springCfgPath) throws Exception {
        Map cfgMap;
        GenericApplicationContext springCtx;
        URL url;
        block7: {
            try {
                url = new URL(springCfgPath);
            }
            catch (MalformedURLException e) {
                url = IgniteUtils.resolveIgniteUrl((String)springCfgPath);
                if (url != null) break block7;
                throw new IgniteCheckedException("Spring XML configuration path is invalid: " + springCfgPath + ". Note that this path should be either absolute or a relative local file system path, relative to META-INF in classpath or valid URL to IGNITE_HOME.", (Throwable)e);
            }
        }
        try {
            springCtx = new GenericApplicationContext();
            new XmlBeanDefinitionReader((BeanDefinitionRegistry)springCtx).loadBeanDefinitions((Resource)new UrlResource(url));
            springCtx.refresh();
        }
        catch (BeansException e) {
            throw new Exception("Failed to instantiate Spring XML application context [springUrl=" + url + ", err=" + e.getMessage() + ']', e);
        }
        try {
            cfgMap = springCtx.getBeansOfType(IgniteConfiguration.class);
        }
        catch (BeansException e) {
            throw new Exception("Failed to instantiate bean [type=" + IgniteConfiguration.class + ", err=" + e.getMessage() + ']', e);
        }
        if (cfgMap == null || cfgMap.isEmpty()) {
            throw new Exception("Failed to find ignite configuration in: " + url);
        }
        return new IgniteBiTuple(cfgMap.values().iterator().next(), (Object)springCtx);
    }

    public IgniteClient client() {
        return this.client;
    }
}

