/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.yardstick;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import javax.cache.CacheException;
import org.apache.ignite.IgniteTransactions;
import org.apache.ignite.Ignition;
import org.apache.ignite.cluster.ClusterTopologyException;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.transactions.Transaction;
import org.apache.ignite.transactions.TransactionConcurrency;
import org.apache.ignite.transactions.TransactionIsolation;
import org.apache.ignite.transactions.TransactionOptimisticException;
import org.apache.ignite.transactions.TransactionRollbackException;
import org.apache.ignite.yardstick.IgniteNode;
import org.apache.ignite.yardstick.PreloadLogger;
import org.apache.ignite.yardstick.cache.IgnitePutBenchmark;
import org.yardstickframework.BenchmarkConfiguration;
import org.yardstickframework.BenchmarkDriverStartUp;
import org.yardstickframework.BenchmarkUtils;

public class IgniteBenchmarkUtils {
    private static final ScheduledExecutorService exec = Executors.newSingleThreadScheduledExecutor(new ThreadFactory(){

        @Override
        public Thread newThread(Runnable run) {
            Thread thread = Executors.defaultThreadFactory().newThread(run);
            thread.setDaemon(true);
            return thread;
        }
    });

    private IgniteBenchmarkUtils() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> T doInTransaction(IgniteTransactions igniteTx, TransactionConcurrency txConcurrency, TransactionIsolation txIsolation, Callable<T> clo) throws Exception {
        while (true) {
            try (Transaction tx = igniteTx.txStart(txConcurrency, txIsolation);){
                T res = clo.call();
                tx.commit();
                T t = res;
                return t;
            }
            catch (CacheException e) {
                if (!(e.getCause() instanceof ClusterTopologyException)) throw e;
                ClusterTopologyException topEx = (ClusterTopologyException)e.getCause();
                topEx.retryReadyFuture().get();
                continue;
            }
            catch (ClusterTopologyException e) {
                e.retryReadyFuture().get();
                continue;
            }
            catch (TransactionOptimisticException | TransactionRollbackException throwable6) {
                continue;
            }
            break;
        }
    }

    public static void main(String[] args) throws Exception {
        String cfg = "modules/yardstick/config/ignite-localhost-config.xml";
        Class<IgnitePutBenchmark> benchmark = IgnitePutBenchmark.class;
        boolean threads = true;
        boolean clientDriverNode = true;
        boolean extraNodes = true;
        int warmUp = 60;
        int duration = 120;
        int range = 100000;
        boolean throughputLatencyProbe = false;
        for (int i = 0; i < 1; ++i) {
            IgniteConfiguration nodeCfg = (IgniteConfiguration)Ignition.loadSpringBean((String)"modules/yardstick/config/ignite-localhost-config.xml", (String)"grid.cfg");
            nodeCfg.setIgniteInstanceName("node-" + i);
            nodeCfg.setMetricsLogFrequency(0L);
            Ignition.start((IgniteConfiguration)nodeCfg);
        }
        ArrayList<String> args0 = new ArrayList<String>();
        IgniteBenchmarkUtils.addArg(args0, "-t", 1);
        IgniteBenchmarkUtils.addArg(args0, "-w", 60);
        IgniteBenchmarkUtils.addArg(args0, "-d", 120);
        IgniteBenchmarkUtils.addArg(args0, "-r", 100000);
        IgniteBenchmarkUtils.addArg(args0, "-dn", benchmark.getSimpleName());
        IgniteBenchmarkUtils.addArg(args0, "-sn", "IgniteNode");
        IgniteBenchmarkUtils.addArg(args0, "-cfg", "modules/yardstick/config/ignite-localhost-config.xml");
        IgniteBenchmarkUtils.addArg(args0, "-wom", "PRIMARY");
        args0.add("-cl");
        BenchmarkDriverStartUp.main((String[])args0.toArray(new String[args0.size()]));
    }

    private static void addArg(List<String> args, String arg, Object val) {
        args.add(arg);
        args.add(val.toString());
    }

    public static PreloadLogger startPreloadLogger(IgniteNode node, BenchmarkConfiguration cfg, long logsInterval) {
        PreloadLogger lgr = new PreloadLogger(node, cfg);
        ScheduledFuture<?> fut = exec.scheduleWithFixedDelay(lgr, 0L, logsInterval, TimeUnit.MILLISECONDS);
        lgr.setFuture(fut);
        BenchmarkUtils.println((BenchmarkConfiguration)cfg, (String)"Preload logger was started.");
        return lgr;
    }
}

