/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.runtime.operators.windowing;

import java.io.IOException;
import java.util.ArrayDeque;
import java.util.Iterator;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.streaming.api.operators.AbstractStreamOperator;
import org.apache.flink.streaming.api.windowing.windows.TimeWindow;
import org.apache.flink.streaming.runtime.operators.windowing.KeyMap;
import org.apache.flink.util.Collector;

@Internal
public abstract class AbstractKeyedTimePanes<Type, Key, Aggregate, Result> {
    private static final int BEGIN_OF_STATE_MAGIC_NUMBER = 267505218;
    private static final int BEGIN_OF_PANE_MAGIC_NUMBER = -1159790379;
    protected KeyMap<Key, Aggregate> latestPane = new KeyMap();
    protected final ArrayDeque<KeyMap<Key, Aggregate>> previousPanes = new ArrayDeque();

    public abstract void addElementToLatestPane(Type var1) throws Exception;

    public abstract void evaluateWindow(Collector<Result> var1, TimeWindow var2, AbstractStreamOperator<Result> var3) throws Exception;

    public void dispose() {
        this.latestPane = null;
        this.previousPanes.clear();
    }

    public int getNumPanes() {
        return this.previousPanes.size() + 1;
    }

    public void slidePanes(int panesToKeep) {
        if (panesToKeep > 1) {
            this.previousPanes.addLast(this.latestPane);
            while (this.previousPanes.size() >= panesToKeep) {
                this.previousPanes.removeFirst();
            }
        }
        this.latestPane = new KeyMap();
    }

    public void truncatePanes(int numToRetain) {
        while (this.previousPanes.size() >= numToRetain) {
            this.previousPanes.removeFirst();
        }
    }

    protected void traverseAllPanes(KeyMap.TraversalEvaluator<Key, Aggregate> traversal, long traversalPass) throws Exception {
        KeyMap[] panes = this.previousPanes.toArray(new KeyMap[this.previousPanes.size() + 1]);
        panes[panes.length - 1] = this.latestPane;
        KeyMap.traverseMaps(panes, traversal, traversalPass);
    }

    public void writeToOutput(DataOutputView output, TypeSerializer<Key> keySerializer, TypeSerializer<Aggregate> aggSerializer) throws IOException {
        output.writeInt(267505218);
        int numPanes = this.getNumPanes();
        output.writeInt(numPanes);
        Iterator<KeyMap<Key, Aggregate>> previous = this.previousPanes.iterator();
        for (int paneNum = 0; paneNum < numPanes; ++paneNum) {
            output.writeInt(-1159790379);
            KeyMap<Key, Aggregate> pane = paneNum == numPanes - 1 ? this.latestPane : previous.next();
            output.writeInt(pane.size());
            for (KeyMap.Entry<Key, Aggregate> entry : pane) {
                keySerializer.serialize(entry.getKey(), output);
                aggSerializer.serialize(entry.getValue(), output);
            }
        }
    }

    public void readFromInput(DataInputView input, TypeSerializer<Key> keySerializer, TypeSerializer<Aggregate> aggSerializer) throws IOException {
        AbstractKeyedTimePanes.validateMagicNumber(267505218, input.readInt());
        for (int numPanes = input.readInt(); numPanes > 0; --numPanes) {
            AbstractKeyedTimePanes.validateMagicNumber(-1159790379, input.readInt());
            KeyMap<Object, Object> pane = numPanes == 1 ? this.latestPane : new KeyMap<Object, Object>();
            int numElementsInPane = input.readInt();
            for (int i = numElementsInPane - 1; i >= 0; --i) {
                Object k = keySerializer.deserialize(input);
                Object a = aggSerializer.deserialize(input);
                pane.put(k, a);
            }
            if (numPanes <= 1) continue;
            this.previousPanes.addLast(pane);
        }
    }

    private static void validateMagicNumber(int expected, int found) throws IOException {
        if (expected != found) {
            throw new IOException("Corrupt state stream - wrong magic number. Expected '" + Integer.toHexString(expected) + "', found '" + Integer.toHexString(found) + '\'');
        }
    }
}

